/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.jcajce.provider.symmetric;

import net.savignano.thirdparty.org.bouncycastle.crypto.CipherKeyGenerator;
import net.savignano.thirdparty.org.bouncycastle.crypto.engines.Salsa20Engine;
import net.savignano.thirdparty.org.bouncycastle.jcajce.provider.config.ConfigurableProvider;
import net.savignano.thirdparty.org.bouncycastle.jcajce.provider.symmetric.util.BaseKeyGenerator;
import net.savignano.thirdparty.org.bouncycastle.jcajce.provider.symmetric.util.BaseStreamCipher;
import net.savignano.thirdparty.org.bouncycastle.jcajce.provider.symmetric.util.IvAlgorithmParameters;
import net.savignano.thirdparty.org.bouncycastle.jcajce.provider.util.AlgorithmProvider;

public final class Salsa20 {
    private Salsa20() {
    }

    public static class Mappings
    extends AlgorithmProvider {
        private static final String PREFIX = Salsa20.class.getName();

        @Override
        public void configure(ConfigurableProvider provider) {
            provider.addAlgorithm("Cipher.SALSA20", PREFIX + "$Base");
            provider.addAlgorithm("KeyGenerator.SALSA20", PREFIX + "$KeyGen");
            provider.addAlgorithm("AlgorithmParameters.SALSA20", PREFIX + "$AlgParams");
        }
    }

    public static class AlgParams
    extends IvAlgorithmParameters {
        @Override
        protected String engineToString() {
            return "Salsa20 IV";
        }
    }

    public static class KeyGen
    extends BaseKeyGenerator {
        public KeyGen() {
            super("Salsa20", 128, new CipherKeyGenerator());
        }
    }

    public static class Base
    extends BaseStreamCipher {
        public Base() {
            super(new Salsa20Engine(), 8);
        }
    }
}

