/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.oer.its.ieee1609dot2.basetypes;

import java.math.BigInteger;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Integer;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Object;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Primitive;
import net.savignano.thirdparty.org.bouncycastle.util.BigIntegers;

public class IValue
extends ASN1Object {
    private final BigInteger value;

    private IValue(ASN1Integer value) {
        int i = BigIntegers.intValueExact(value.getValue());
        if (i < 0 || i > 65535) {
            throw new IllegalArgumentException("value out of range");
        }
        this.value = value.getValue();
    }

    public static IValue getInstance(Object src) {
        if (src instanceof IValue) {
            return (IValue)src;
        }
        if (src != null) {
            return new IValue(ASN1Integer.getInstance(src));
        }
        return null;
    }

    public BigInteger getValue() {
        return this.value;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        return new ASN1Integer(this.value);
    }
}

