/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.openpgp.operator;

import java.io.IOException;
import java.io.OutputStream;
import net.savignano.thirdparty.org.bouncycastle.bcpg.HashAlgorithmTags;
import net.savignano.thirdparty.org.bouncycastle.bcpg.S2K;
import net.savignano.thirdparty.org.bouncycastle.crypto.generators.Argon2BytesGenerator;
import net.savignano.thirdparty.org.bouncycastle.crypto.params.Argon2Parameters;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPException;
import net.savignano.thirdparty.org.bouncycastle.openpgp.operator.PGPDigestCalculator;
import net.savignano.thirdparty.org.bouncycastle.openpgp.operator.PGPDigestCalculatorProvider;
import net.savignano.thirdparty.org.bouncycastle.util.Strings;

class PGPUtil
implements HashAlgorithmTags {
    PGPUtil() {
    }

    static byte[] makeKeyFromPassPhrase(PGPDigestCalculator digestCalculator, int algorithm, S2K s2k, char[] passPhrase) throws PGPException {
        int keySize;
        switch (algorithm) {
            case 2: 
            case 8: 
            case 12: {
                keySize = 192;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 11: {
                keySize = 128;
                break;
            }
            case 6: {
                keySize = 64;
                break;
            }
            case 9: 
            case 10: 
            case 13: {
                keySize = 256;
                break;
            }
            default: {
                throw new PGPException("unknown symmetric algorithm: " + algorithm);
            }
        }
        byte[] pBytes = Strings.toUTF8ByteArray(passPhrase);
        byte[] keyBytes = new byte[(keySize + 7) / 8];
        int generatedBytes = 0;
        int loopCount = 0;
        if (s2k != null) {
            if (s2k.getType() == 4) {
                Argon2Parameters.Builder builder = new Argon2Parameters.Builder(2).withSalt(s2k.getIV()).withIterations(s2k.getPasses()).withParallelism(s2k.getParallelism()).withMemoryPowOfTwo(s2k.getMemorySizeExponent()).withVersion(19);
                Argon2BytesGenerator argon2 = new Argon2BytesGenerator();
                argon2.init(builder.build());
                argon2.generateBytes(passPhrase, keyBytes);
                return keyBytes;
            }
            if (s2k.getHashAlgorithm() != digestCalculator.getAlgorithm()) {
                throw new PGPException("s2k/digestCalculator mismatch");
            }
        } else if (digestCalculator.getAlgorithm() != 1) {
            throw new PGPException("digestCalculator not for MD5");
        }
        OutputStream dOut = digestCalculator.getOutputStream();
        try {
            while (generatedBytes < keyBytes.length) {
                block28: {
                    block27: {
                        if (s2k == null) break block27;
                        for (int i = 0; i != loopCount; ++i) {
                            dOut.write(0);
                        }
                        byte[] iv = s2k.getIV();
                        block7 : switch (s2k.getType()) {
                            case 0: {
                                dOut.write(pBytes);
                                break;
                            }
                            case 1: {
                                dOut.write(iv);
                                dOut.write(pBytes);
                                break;
                            }
                            case 3: {
                                long count = s2k.getIterationCount();
                                dOut.write(iv);
                                dOut.write(pBytes);
                                count -= (long)(iv.length + pBytes.length);
                                while (count > 0L) {
                                    if (count < (long)iv.length) {
                                        dOut.write(iv, 0, (int)count);
                                        break block7;
                                    }
                                    dOut.write(iv);
                                    if ((count -= (long)iv.length) < (long)pBytes.length) {
                                        dOut.write(pBytes, 0, (int)count);
                                        count = 0L;
                                        continue;
                                    }
                                    dOut.write(pBytes);
                                    count -= (long)pBytes.length;
                                }
                                break block28;
                            }
                            default: {
                                throw new PGPException("unknown S2K type: " + s2k.getType());
                            }
                        }
                        break block28;
                    }
                    for (int i = 0; i != loopCount; ++i) {
                        dOut.write(0);
                    }
                    dOut.write(pBytes);
                }
                dOut.close();
                byte[] dig = digestCalculator.getDigest();
                if (dig.length > keyBytes.length - generatedBytes) {
                    System.arraycopy(dig, 0, keyBytes, generatedBytes, keyBytes.length - generatedBytes);
                } else {
                    System.arraycopy(dig, 0, keyBytes, generatedBytes, dig.length);
                }
                generatedBytes += dig.length;
                ++loopCount;
            }
        }
        catch (IOException e) {
            throw new PGPException("exception calculating digest: " + e.getMessage(), e);
        }
        for (int i = 0; i != pBytes.length; ++i) {
            pBytes[i] = 0;
        }
        return keyBytes;
    }

    public static byte[] makeKeyFromPassPhrase(PGPDigestCalculatorProvider digCalcProvider, int algorithm, S2K s2k, char[] passPhrase) throws PGPException {
        PGPDigestCalculator digestCalculator = s2k != null && s2k.getType() != 4 ? digCalcProvider.get(s2k.getHashAlgorithm()) : digCalcProvider.get(1);
        return PGPUtil.makeKeyFromPassPhrase(digestCalculator, algorithm, s2k, passPhrase);
    }
}

