/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.openpgp.operator.jcajce;

import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.Provider;
import java.security.SecureRandom;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import net.savignano.thirdparty.org.bouncycastle.bcpg.SymmetricKeyUtils;
import net.savignano.thirdparty.org.bouncycastle.crypto.InvalidCipherTextException;
import net.savignano.thirdparty.org.bouncycastle.crypto.digests.SHA256Digest;
import net.savignano.thirdparty.org.bouncycastle.crypto.generators.HKDFBytesGenerator;
import net.savignano.thirdparty.org.bouncycastle.crypto.modes.AEADBlockCipher;
import net.savignano.thirdparty.org.bouncycastle.crypto.params.AEADParameters;
import net.savignano.thirdparty.org.bouncycastle.crypto.params.HKDFParameters;
import net.savignano.thirdparty.org.bouncycastle.crypto.params.KeyParameter;
import net.savignano.thirdparty.org.bouncycastle.jcajce.util.DefaultJcaJceHelper;
import net.savignano.thirdparty.org.bouncycastle.jcajce.util.NamedJcaJceHelper;
import net.savignano.thirdparty.org.bouncycastle.jcajce.util.ProviderJcaJceHelper;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPException;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPUtil;
import net.savignano.thirdparty.org.bouncycastle.openpgp.operator.PBEKeyEncryptionMethodGenerator;
import net.savignano.thirdparty.org.bouncycastle.openpgp.operator.PGPDigestCalculator;
import net.savignano.thirdparty.org.bouncycastle.openpgp.operator.bc.BcAEADUtil;
import net.savignano.thirdparty.org.bouncycastle.openpgp.operator.jcajce.OperatorHelper;
import net.savignano.thirdparty.org.bouncycastle.openpgp.operator.jcajce.SHA1PGPDigestCalculator;

public class JcePBEKeyEncryptionMethodGenerator
extends PBEKeyEncryptionMethodGenerator {
    private OperatorHelper helper = new OperatorHelper(new DefaultJcaJceHelper());

    public JcePBEKeyEncryptionMethodGenerator(char[] passPhrase, PGPDigestCalculator s2kDigestCalculator) {
        super(passPhrase, s2kDigestCalculator);
    }

    public JcePBEKeyEncryptionMethodGenerator(char[] passPhrase) {
        this(passPhrase, new SHA1PGPDigestCalculator());
    }

    public JcePBEKeyEncryptionMethodGenerator(char[] passPhrase, PGPDigestCalculator s2kDigestCalculator, int s2kCount) {
        super(passPhrase, s2kDigestCalculator, s2kCount);
    }

    public JcePBEKeyEncryptionMethodGenerator(char[] passPhrase, int s2kCount) {
        super(passPhrase, new SHA1PGPDigestCalculator(), s2kCount);
    }

    public JcePBEKeyEncryptionMethodGenerator setProvider(Provider provider) {
        this.helper = new OperatorHelper(new ProviderJcaJceHelper(provider));
        return this;
    }

    public JcePBEKeyEncryptionMethodGenerator setProvider(String providerName) {
        this.helper = new OperatorHelper(new NamedJcaJceHelper(providerName));
        return this;
    }

    @Override
    public PBEKeyEncryptionMethodGenerator setSecureRandom(SecureRandom random) {
        super.setSecureRandom(random);
        return this;
    }

    @Override
    protected byte[] encryptSessionInfo(int encAlgorithm, byte[] key, byte[] sessionInfo) throws PGPException {
        try {
            String cName = PGPUtil.getSymmetricCipherName(encAlgorithm);
            Cipher c = this.helper.createCipher(cName + "/CFB/NoPadding");
            SecretKeySpec sKey = new SecretKeySpec(key, PGPUtil.getSymmetricCipherName(encAlgorithm));
            c.init(1, (Key)sKey, new IvParameterSpec(new byte[c.getBlockSize()]));
            return c.doFinal(sessionInfo, 0, sessionInfo.length);
        }
        catch (IllegalBlockSizeException e) {
            throw new PGPException("illegal block size: " + e.getMessage(), e);
        }
        catch (BadPaddingException e) {
            throw new PGPException("bad padding: " + e.getMessage(), e);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new PGPException("IV invalid: " + e.getMessage(), e);
        }
        catch (InvalidKeyException e) {
            throw new PGPException("key invalid: " + e.getMessage(), e);
        }
    }

    @Override
    protected byte[] generateV6KEK(int kekAlgorithm, byte[] ikm, byte[] info) throws PGPException {
        HKDFBytesGenerator hkdf = new HKDFBytesGenerator(new SHA256Digest());
        hkdf.init(new HKDFParameters(ikm, null, info));
        int kekLen = SymmetricKeyUtils.getKeyLengthInOctets(kekAlgorithm);
        byte[] kek = new byte[kekLen];
        hkdf.generateBytes(kek, 0, kek.length);
        return kek;
    }

    @Override
    protected byte[] getEskAndTag(int kekAlgorithm, int aeadAlgorithm, byte[] sessionInfo, byte[] key, byte[] iv, byte[] info) throws PGPException {
        byte[] sessionKey = new byte[sessionInfo.length - 3];
        System.arraycopy(sessionInfo, 1, sessionKey, 0, sessionKey.length);
        AEADBlockCipher aeadCipher = BcAEADUtil.createAEADCipher(kekAlgorithm, aeadAlgorithm);
        aeadCipher.init(true, new AEADParameters(new KeyParameter(key), 128, iv, info));
        int outLen = aeadCipher.getOutputSize(sessionKey.length);
        byte[] eskAndTag = new byte[outLen];
        int len = aeadCipher.processBytes(sessionKey, 0, sessionKey.length, eskAndTag, 0);
        try {
            len += aeadCipher.doFinal(eskAndTag, len);
        }
        catch (InvalidCipherTextException e) {
            throw new PGPException("cannot encrypt session info", e);
        }
        return eskAndTag;
    }
}

