/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.openpgp.operator.jcajce;

import java.io.OutputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.Provider;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import net.savignano.thirdparty.org.bouncycastle.bcpg.AEADUtils;
import net.savignano.thirdparty.org.bouncycastle.bcpg.SymmetricKeyUtils;
import net.savignano.thirdparty.org.bouncycastle.jcajce.io.CipherOutputStream;
import net.savignano.thirdparty.org.bouncycastle.jcajce.util.DefaultJcaJceHelper;
import net.savignano.thirdparty.org.bouncycastle.jcajce.util.NamedJcaJceHelper;
import net.savignano.thirdparty.org.bouncycastle.jcajce.util.ProviderJcaJceHelper;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPException;
import net.savignano.thirdparty.org.bouncycastle.openpgp.operator.PGPAEADDataEncryptor;
import net.savignano.thirdparty.org.bouncycastle.openpgp.operator.PGPDataEncryptor;
import net.savignano.thirdparty.org.bouncycastle.openpgp.operator.PGPDataEncryptorBuilder;
import net.savignano.thirdparty.org.bouncycastle.openpgp.operator.PGPDigestCalculator;
import net.savignano.thirdparty.org.bouncycastle.openpgp.operator.jcajce.JcaJcePGPUtil;
import net.savignano.thirdparty.org.bouncycastle.openpgp.operator.jcajce.JceAEADUtil;
import net.savignano.thirdparty.org.bouncycastle.openpgp.operator.jcajce.OperatorHelper;
import net.savignano.thirdparty.org.bouncycastle.openpgp.operator.jcajce.SHA1PGPDigestCalculator;
import net.savignano.thirdparty.org.bouncycastle.util.Arrays;

public class JcePGPDataEncryptorBuilder
implements PGPDataEncryptorBuilder {
    private final int encAlgorithm;
    private OperatorHelper helper = new OperatorHelper(new DefaultJcaJceHelper());
    private JceAEADUtil aeadHelper = new JceAEADUtil(this.helper);
    private SecureRandom random;
    private boolean withIntegrityPacket = true;
    private int aeadAlgorithm = -1;
    private int chunkSize;
    private boolean isV5StyleAEAD = true;

    public JcePGPDataEncryptorBuilder(int encAlgorithm) {
        this.encAlgorithm = encAlgorithm;
        if (encAlgorithm == 0) {
            throw new IllegalArgumentException("null cipher specified");
        }
    }

    @Override
    public JcePGPDataEncryptorBuilder setWithIntegrityPacket(boolean withIntegrityPacket) {
        this.withIntegrityPacket = withIntegrityPacket;
        return this;
    }

    @Override
    public JcePGPDataEncryptorBuilder setWithAEAD(int aeadAlgorithm, int chunkSize) {
        if (this.encAlgorithm != 7 && this.encAlgorithm != 8 && this.encAlgorithm != 9 && this.encAlgorithm != 11 && this.encAlgorithm != 12 && this.encAlgorithm != 13) {
            throw new IllegalStateException("AEAD algorithms can only be used with AES and Camellia");
        }
        if (chunkSize < 6) {
            throw new IllegalArgumentException("minimum chunkSize is 6");
        }
        this.aeadAlgorithm = aeadAlgorithm;
        this.chunkSize = chunkSize - 6;
        return this;
    }

    @Override
    public JcePGPDataEncryptorBuilder setUseV5AEAD() {
        this.isV5StyleAEAD = true;
        return this;
    }

    @Override
    public JcePGPDataEncryptorBuilder setUseV6AEAD() {
        this.isV5StyleAEAD = false;
        return this;
    }

    public JcePGPDataEncryptorBuilder setProvider(Provider provider) {
        this.helper = new OperatorHelper(new ProviderJcaJceHelper(provider));
        this.aeadHelper = new JceAEADUtil(this.helper);
        return this;
    }

    public JcePGPDataEncryptorBuilder setProvider(String providerName) {
        this.helper = new OperatorHelper(new NamedJcaJceHelper(providerName));
        this.aeadHelper = new JceAEADUtil(this.helper);
        return this;
    }

    public JcePGPDataEncryptorBuilder setSecureRandom(SecureRandom random) {
        this.random = random;
        return this;
    }

    @Override
    public int getAlgorithm() {
        return this.encAlgorithm;
    }

    @Override
    public int getAeadAlgorithm() {
        return this.aeadAlgorithm;
    }

    @Override
    public int getChunkSize() {
        return this.chunkSize;
    }

    @Override
    public boolean isV5StyleAEAD() {
        return this.isV5StyleAEAD;
    }

    @Override
    public SecureRandom getSecureRandom() {
        if (this.random == null) {
            this.random = new SecureRandom();
        }
        return this.random;
    }

    @Override
    public PGPDataEncryptor build(byte[] keyBytes) throws PGPException {
        if (this.aeadAlgorithm > 0) {
            return new MyAeadDataEncryptor(keyBytes);
        }
        return new MyPGPDataEncryptor(keyBytes);
    }

    private class MyAeadDataEncryptor
    implements PGPAEADDataEncryptor {
        private final boolean isV5StyleAEAD;
        private final Cipher c;
        private final byte[] keyBytes;
        private final byte[] iv;

        MyAeadDataEncryptor(byte[] keyBytes) throws PGPException {
            boolean bl = this.isV5StyleAEAD = keyBytes.length == SymmetricKeyUtils.getKeyLengthInOctets(JcePGPDataEncryptorBuilder.this.encAlgorithm);
            if (this.isV5StyleAEAD) {
                this.keyBytes = keyBytes;
                this.iv = new byte[AEADUtils.getIVLength((byte)JcePGPDataEncryptorBuilder.this.aeadAlgorithm)];
                JcePGPDataEncryptorBuilder.this.getSecureRandom().nextBytes(this.iv);
            } else {
                byte[][] keyAndIv = AEADUtils.splitMessageKeyAndIv(keyBytes, JcePGPDataEncryptorBuilder.this.encAlgorithm, JcePGPDataEncryptorBuilder.this.aeadAlgorithm);
                this.keyBytes = keyAndIv[0];
                this.iv = keyAndIv[1];
            }
            this.c = JcePGPDataEncryptorBuilder.this.aeadHelper.createAEADCipher(JcePGPDataEncryptorBuilder.this.encAlgorithm, JcePGPDataEncryptorBuilder.this.aeadAlgorithm);
        }

        @Override
        public OutputStream getOutputStream(OutputStream out) {
            try {
                return new JceAEADUtil.PGPAeadOutputStream(this.isV5StyleAEAD, out, this.c, JcaJcePGPUtil.makeSymmetricKey(JcePGPDataEncryptorBuilder.this.encAlgorithm, this.keyBytes), this.iv, JcePGPDataEncryptorBuilder.this.encAlgorithm, JcePGPDataEncryptorBuilder.this.aeadAlgorithm, JcePGPDataEncryptorBuilder.this.chunkSize);
            }
            catch (Exception e) {
                throw new IllegalStateException("unable to process stream: " + e.getMessage());
            }
        }

        @Override
        public PGPDigestCalculator getIntegrityCalculator() {
            return null;
        }

        @Override
        public int getBlockSize() {
            return this.c.getBlockSize();
        }

        @Override
        public int getAEADAlgorithm() {
            return JcePGPDataEncryptorBuilder.this.aeadAlgorithm;
        }

        @Override
        public int getChunkSize() {
            return JcePGPDataEncryptorBuilder.this.chunkSize;
        }

        @Override
        public byte[] getIV() {
            return Arrays.clone(this.iv);
        }
    }

    private class MyPGPDataEncryptor
    implements PGPDataEncryptor {
        private final Cipher c;

        MyPGPDataEncryptor(byte[] keyBytes) throws PGPException {
            this.c = JcePGPDataEncryptorBuilder.this.helper.createStreamCipher(JcePGPDataEncryptorBuilder.this.encAlgorithm, JcePGPDataEncryptorBuilder.this.withIntegrityPacket);
            try {
                if (JcePGPDataEncryptorBuilder.this.withIntegrityPacket) {
                    this.c.init(1, (Key)JcaJcePGPUtil.makeSymmetricKey(JcePGPDataEncryptorBuilder.this.encAlgorithm, keyBytes), new IvParameterSpec(new byte[this.c.getBlockSize()]));
                } else {
                    this.c.init(1, JcaJcePGPUtil.makeSymmetricKey(JcePGPDataEncryptorBuilder.this.encAlgorithm, keyBytes));
                }
            }
            catch (InvalidKeyException e) {
                throw new PGPException("invalid key: " + e.getMessage(), e);
            }
            catch (InvalidAlgorithmParameterException e) {
                throw new PGPException("imvalid algorithm parameter: " + e.getMessage(), e);
            }
        }

        @Override
        public OutputStream getOutputStream(OutputStream out) {
            return new CipherOutputStream(out, this.c);
        }

        @Override
        public PGPDigestCalculator getIntegrityCalculator() {
            if (JcePGPDataEncryptorBuilder.this.withIntegrityPacket) {
                return new SHA1PGPDigestCalculator();
            }
            return null;
        }

        @Override
        public int getBlockSize() {
            return this.c.getBlockSize();
        }
    }
}

