/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.pqc.crypto.falcon;

import java.security.SecureRandom;
import net.savignano.thirdparty.org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import net.savignano.thirdparty.org.bouncycastle.crypto.AsymmetricCipherKeyPairGenerator;
import net.savignano.thirdparty.org.bouncycastle.crypto.KeyGenerationParameters;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.falcon.FalconKeyGenerationParameters;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.falcon.FalconNIST;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.falcon.FalconParameters;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.falcon.FalconPrivateKeyParameters;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.falcon.FalconPublicKeyParameters;

public class FalconKeyPairGenerator
implements AsymmetricCipherKeyPairGenerator {
    private FalconKeyGenerationParameters params;
    private SecureRandom random;
    private FalconNIST nist;
    private int logn;
    private int noncelen;
    private int pk_size;
    private int sk_size;

    @Override
    public void init(KeyGenerationParameters param) {
        this.params = (FalconKeyGenerationParameters)param;
        this.random = param.getRandom();
        this.logn = ((FalconKeyGenerationParameters)param).getParameters().getLogN();
        this.noncelen = ((FalconKeyGenerationParameters)param).getParameters().getNonceLength();
        this.nist = new FalconNIST(this.logn, this.noncelen, this.random);
        int n = 1 << this.logn;
        int sk_coeff_size = 8;
        if (n == 1024) {
            sk_coeff_size = 5;
        } else if (n == 256 || n == 512) {
            sk_coeff_size = 6;
        } else if (n == 64 || n == 128) {
            sk_coeff_size = 7;
        }
        this.pk_size = 1 + 14 * n / 8;
        this.sk_size = 1 + 2 * sk_coeff_size * n / 8 + n;
    }

    @Override
    public AsymmetricCipherKeyPair generateKeyPair() {
        byte[] pk = new byte[this.pk_size];
        byte[] sk = new byte[this.sk_size];
        byte[][] keyData = this.nist.crypto_sign_keypair(pk, 0, sk, 0);
        FalconParameters p = this.params.getParameters();
        FalconPrivateKeyParameters privk = new FalconPrivateKeyParameters(p, keyData[1], keyData[2], keyData[3], keyData[0]);
        FalconPublicKeyParameters pubk = new FalconPublicKeyParameters(p, keyData[0]);
        return new AsymmetricCipherKeyPair(pubk, privk);
    }
}

