/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.pqc.crypto.saber;

import java.security.SecureRandom;
import net.savignano.thirdparty.org.bouncycastle.crypto.EncapsulatedSecretGenerator;
import net.savignano.thirdparty.org.bouncycastle.crypto.SecretWithEncapsulation;
import net.savignano.thirdparty.org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.saber.SABEREngine;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.saber.SABERPublicKeyParameters;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.util.SecretWithEncapsulationImpl;

public class SABERKEMGenerator
implements EncapsulatedSecretGenerator {
    private final SecureRandom sr;

    public SABERKEMGenerator(SecureRandom random) {
        this.sr = random;
    }

    @Override
    public SecretWithEncapsulation generateEncapsulated(AsymmetricKeyParameter recipientKey) {
        SABERPublicKeyParameters key = (SABERPublicKeyParameters)recipientKey;
        SABEREngine engine = key.getParameters().getEngine();
        byte[] cipher_text = new byte[engine.getCipherTextSize()];
        byte[] sessionKey = new byte[engine.getSessionKeySize()];
        engine.crypto_kem_enc(cipher_text, sessionKey, key.getPublicKey(), this.sr);
        return new SecretWithEncapsulationImpl(sessionKey, cipher_text);
    }
}

