/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.pqc.jcajce.provider.hqc;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.PublicKey;
import net.savignano.thirdparty.org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.hqc.HQCPublicKeyParameters;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.util.PublicKeyFactory;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.util.SubjectPublicKeyInfoFactory;
import net.savignano.thirdparty.org.bouncycastle.pqc.jcajce.interfaces.HQCKey;
import net.savignano.thirdparty.org.bouncycastle.pqc.jcajce.spec.HQCParameterSpec;
import net.savignano.thirdparty.org.bouncycastle.util.Arrays;
import net.savignano.thirdparty.org.bouncycastle.util.Strings;

public class BCHQCPublicKey
implements PublicKey,
HQCKey {
    private static final long serialVersionUID = 1L;
    private transient HQCPublicKeyParameters params;

    public BCHQCPublicKey(HQCPublicKeyParameters params) {
        this.params = params;
    }

    public BCHQCPublicKey(SubjectPublicKeyInfo keyInfo) throws IOException {
        this.init(keyInfo);
    }

    private void init(SubjectPublicKeyInfo keyInfo) throws IOException {
        this.params = (HQCPublicKeyParameters)PublicKeyFactory.createKey(keyInfo);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof BCHQCPublicKey) {
            BCHQCPublicKey otherKey = (BCHQCPublicKey)o;
            return Arrays.areEqual(this.params.getEncoded(), otherKey.params.getEncoded());
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(this.params.getEncoded());
    }

    @Override
    public final String getAlgorithm() {
        return Strings.toUpperCase(this.params.getParameters().getName());
    }

    @Override
    public byte[] getEncoded() {
        try {
            SubjectPublicKeyInfo pki = SubjectPublicKeyInfoFactory.createSubjectPublicKeyInfo(this.params);
            return pki.getEncoded();
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    public String getFormat() {
        return "X.509";
    }

    @Override
    public HQCParameterSpec getParameterSpec() {
        return HQCParameterSpec.fromName(this.params.getParameters().getName());
    }

    HQCPublicKeyParameters getKeyParams() {
        return this.params;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        byte[] enc = (byte[])in.readObject();
        this.init(SubjectPublicKeyInfo.getInstance(enc));
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeObject(this.getEncoded());
    }
}

