/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.pqc.jcajce.provider.kyber;

import java.security.InvalidAlgorithmParameterException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.util.HashMap;
import java.util.Map;
import net.savignano.thirdparty.org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import net.savignano.thirdparty.org.bouncycastle.crypto.CryptoServicesRegistrar;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.crystals.kyber.KyberKeyGenerationParameters;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.crystals.kyber.KyberKeyPairGenerator;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.crystals.kyber.KyberParameters;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.crystals.kyber.KyberPrivateKeyParameters;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.crystals.kyber.KyberPublicKeyParameters;
import net.savignano.thirdparty.org.bouncycastle.pqc.jcajce.provider.kyber.BCKyberPrivateKey;
import net.savignano.thirdparty.org.bouncycastle.pqc.jcajce.provider.kyber.BCKyberPublicKey;
import net.savignano.thirdparty.org.bouncycastle.pqc.jcajce.provider.util.SpecUtil;
import net.savignano.thirdparty.org.bouncycastle.pqc.jcajce.spec.KyberParameterSpec;
import net.savignano.thirdparty.org.bouncycastle.util.Strings;

public class KyberKeyPairGeneratorSpi
extends KeyPairGenerator {
    private static Map parameters = new HashMap();
    KyberKeyGenerationParameters param;
    KyberKeyPairGenerator engine = new KyberKeyPairGenerator();
    SecureRandom random = CryptoServicesRegistrar.getSecureRandom();
    boolean initialised = false;
    private KyberParameters kyberParameters;

    public KyberKeyPairGeneratorSpi() {
        super("KYBER");
        this.kyberParameters = null;
    }

    protected KyberKeyPairGeneratorSpi(KyberParameters kyberParameters) {
        super(Strings.toUpperCase(kyberParameters.getName()));
        this.kyberParameters = kyberParameters;
    }

    @Override
    public void initialize(int strength, SecureRandom random) {
        throw new IllegalArgumentException("use AlgorithmParameterSpec");
    }

    @Override
    public void initialize(AlgorithmParameterSpec params, SecureRandom random) throws InvalidAlgorithmParameterException {
        String name = KyberKeyPairGeneratorSpi.getNameFromParams(params);
        if (name != null && parameters.containsKey(name)) {
            KyberParameters kyberParams = (KyberParameters)parameters.get(name);
            this.param = new KyberKeyGenerationParameters(random, kyberParams);
            if (this.kyberParameters != null && !kyberParams.getName().equals(this.kyberParameters.getName())) {
                throw new InvalidAlgorithmParameterException("key pair generator locked to " + Strings.toUpperCase(this.kyberParameters.getName()));
            }
        } else {
            throw new InvalidAlgorithmParameterException("invalid ParameterSpec: " + params);
        }
        this.engine.init(this.param);
        this.initialised = true;
    }

    private static String getNameFromParams(AlgorithmParameterSpec paramSpec) {
        if (paramSpec instanceof KyberParameterSpec) {
            KyberParameterSpec kyberParams = (KyberParameterSpec)paramSpec;
            return kyberParams.getName();
        }
        return Strings.toLowerCase(SpecUtil.getNameFrom(paramSpec));
    }

    @Override
    public KeyPair generateKeyPair() {
        if (!this.initialised) {
            this.param = this.kyberParameters != null ? new KyberKeyGenerationParameters(this.random, this.kyberParameters) : new KyberKeyGenerationParameters(this.random, KyberParameters.kyber1024);
            this.engine.init(this.param);
            this.initialised = true;
        }
        AsymmetricCipherKeyPair pair = this.engine.generateKeyPair();
        KyberPublicKeyParameters pub = (KyberPublicKeyParameters)pair.getPublic();
        KyberPrivateKeyParameters priv = (KyberPrivateKeyParameters)pair.getPrivate();
        return new KeyPair(new BCKyberPublicKey(pub), new BCKyberPrivateKey(priv));
    }

    static {
        parameters.put(KyberParameterSpec.kyber512.getName(), KyberParameters.kyber512);
        parameters.put(KyberParameterSpec.kyber768.getName(), KyberParameters.kyber768);
        parameters.put(KyberParameterSpec.kyber1024.getName(), KyberParameters.kyber1024);
    }

    public static class Kyber1024
    extends KyberKeyPairGeneratorSpi {
        public Kyber1024() {
            super(KyberParameters.kyber1024);
        }
    }

    public static class Kyber768
    extends KyberKeyPairGeneratorSpi {
        public Kyber768() {
            super(KyberParameters.kyber768);
        }
    }

    public static class Kyber512
    extends KyberKeyPairGeneratorSpi {
        public Kyber512() {
            super(KyberParameters.kyber512);
        }
    }
}

