/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.pqc.math.ntru;

import net.savignano.thirdparty.org.bouncycastle.pqc.math.ntru.HPSPolynomial;
import net.savignano.thirdparty.org.bouncycastle.pqc.math.ntru.parameters.NTRUHPSParameterSet;

public class HPS4096Polynomial
extends HPSPolynomial {
    public HPS4096Polynomial(NTRUHPSParameterSet params) {
        super(params);
    }

    @Override
    public byte[] sqToBytes(int len) {
        byte[] r = new byte[len];
        int q = this.params.q();
        for (int i = 0; i < this.params.packDegree() / 2; ++i) {
            r[3 * i + 0] = (byte)(HPS4096Polynomial.modQ(this.coeffs[2 * i + 0] & 0xFFFF, q) & 0xFF);
            r[3 * i + 1] = (byte)(HPS4096Polynomial.modQ(this.coeffs[2 * i + 0] & 0xFFFF, q) >>> 8 | (HPS4096Polynomial.modQ(this.coeffs[2 * i + 1] & 0xFFFF, q) & 0xF) << 4);
            r[3 * i + 2] = (byte)(HPS4096Polynomial.modQ(this.coeffs[2 * i + 1] & 0xFFFF, q) >>> 4);
        }
        return r;
    }

    @Override
    public void sqFromBytes(byte[] a) {
        for (int i = 0; i < this.params.packDegree() / 2; ++i) {
            this.coeffs[2 * i + 0] = (short)((a[3 * i + 0] & 0xFF) >>> 0 | ((short)(a[3 * i + 1] & 0xFF) & 0xF) << 8);
            this.coeffs[2 * i + 1] = (short)((a[3 * i + 1] & 0xFF) >>> 4 | ((short)(a[3 * i + 2] & 0xFF) & 0xFF) << 4);
        }
        this.coeffs[this.params.n() - 1] = 0;
    }
}

