/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.pqc.math.ntru;

import net.savignano.thirdparty.org.bouncycastle.pqc.math.ntru.Polynomial;
import net.savignano.thirdparty.org.bouncycastle.pqc.math.ntru.parameters.NTRUHRSSParameterSet;

public class HRSSPolynomial
extends Polynomial {
    public HRSSPolynomial(NTRUHRSSParameterSet params) {
        super(params);
    }

    @Override
    public byte[] sqToBytes(int len) {
        int j;
        int i;
        byte[] r = new byte[len];
        short[] t = new short[8];
        for (i = 0; i < this.params.packDegree() / 8; ++i) {
            for (j = 0; j < 8; ++j) {
                t[j] = (short)HRSSPolynomial.modQ(this.coeffs[8 * i + j] & 0xFFFF, this.params.q());
            }
            r[13 * i + 0] = (byte)(t[0] & 0xFF);
            r[13 * i + 1] = (byte)(t[0] >>> 8 | (t[1] & 7) << 5);
            r[13 * i + 2] = (byte)(t[1] >>> 3 & 0xFF);
            r[13 * i + 3] = (byte)(t[1] >>> 11 | (t[2] & 0x3F) << 2);
            r[13 * i + 4] = (byte)(t[2] >>> 6 | (t[3] & 1) << 7);
            r[13 * i + 5] = (byte)(t[3] >>> 1 & 0xFF);
            r[13 * i + 6] = (byte)(t[3] >>> 9 | (t[4] & 0xF) << 4);
            r[13 * i + 7] = (byte)(t[4] >>> 4 & 0xFF);
            r[13 * i + 8] = (byte)(t[4] >>> 12 | (t[5] & 0x7F) << 1);
            r[13 * i + 9] = (byte)(t[5] >>> 7 | (t[6] & 3) << 6);
            r[13 * i + 10] = (byte)(t[6] >>> 2 & 0xFF);
            r[13 * i + 11] = (byte)(t[6] >>> 10 | (t[7] & 0x1F) << 3);
            r[13 * i + 12] = (byte)(t[7] >>> 5);
        }
        for (j = 0; j < this.params.packDegree() - 8 * i; ++j) {
            t[j] = (short)HRSSPolynomial.modQ(this.coeffs[8 * i + j] & 0xFFFF, this.params.q());
        }
        while (j < 8) {
            t[j] = 0;
            ++j;
        }
        switch (this.params.packDegree() - 8 * (this.params.packDegree() / 8)) {
            case 4: {
                r[13 * i + 0] = (byte)(t[0] & 0xFF);
                r[13 * i + 1] = (byte)(t[0] >>> 8 | (t[1] & 7) << 5);
                r[13 * i + 2] = (byte)(t[1] >>> 3 & 0xFF);
                r[13 * i + 3] = (byte)(t[1] >>> 11 | (t[2] & 0x3F) << 2);
                r[13 * i + 4] = (byte)(t[2] >>> 6 | (t[3] & 1) << 7);
                r[13 * i + 5] = (byte)(t[3] >>> 1 & 0xFF);
                r[13 * i + 6] = (byte)(t[3] >>> 9 | (t[4] & 0xF) << 4);
            }
            case 2: {
                r[13 * i + 0] = (byte)(t[0] & 0xFF);
                r[13 * i + 1] = (byte)(t[0] >>> 8 | (t[1] & 7) << 5);
                r[13 * i + 2] = (byte)(t[1] >>> 3 & 0xFF);
                r[13 * i + 3] = (byte)(t[1] >>> 11 | (t[2] & 0x3F) << 2);
            }
        }
        return r;
    }

    @Override
    public void sqFromBytes(byte[] a) {
        int i;
        for (i = 0; i < this.params.packDegree() / 8; ++i) {
            this.coeffs[8 * i + 0] = (short)(a[13 * i + 0] & 0xFF | ((short)(a[13 * i + 1] & 0xFF) & 0x1F) << 8);
            this.coeffs[8 * i + 1] = (short)((a[13 * i + 1] & 0xFF) >>> 5 | (short)(a[13 * i + 2] & 0xFF) << 3 | ((short)(a[13 * i + 3] & 0xFF) & 3) << 11);
            this.coeffs[8 * i + 2] = (short)((a[13 * i + 3] & 0xFF) >>> 2 | ((short)(a[13 * i + 4] & 0xFF) & 0x7F) << 6);
            this.coeffs[8 * i + 3] = (short)((a[13 * i + 4] & 0xFF) >>> 7 | (short)(a[13 * i + 5] & 0xFF) << 1 | ((short)(a[13 * i + 6] & 0xFF) & 0xF) << 9);
            this.coeffs[8 * i + 4] = (short)((a[13 * i + 6] & 0xFF) >>> 4 | (short)(a[13 * i + 7] & 0xFF) << 4 | ((short)(a[13 * i + 8] & 0xFF) & 1) << 12);
            this.coeffs[8 * i + 5] = (short)((a[13 * i + 8] & 0xFF) >>> 1 | ((short)(a[13 * i + 9] & 0xFF) & 0x3F) << 7);
            this.coeffs[8 * i + 6] = (short)((a[13 * i + 9] & 0xFF) >>> 6 | (short)(a[13 * i + 10] & 0xFF) << 2 | ((short)(a[13 * i + 11] & 0xFF) & 7) << 10);
            this.coeffs[8 * i + 7] = (short)((a[13 * i + 11] & 0xFF) >>> 3 | (short)(a[13 * i + 12] & 0xFF) << 5);
        }
        switch (this.params.packDegree() & 7) {
            case 4: {
                this.coeffs[8 * i + 0] = (short)(a[13 * i + 0] & 0xFF | ((short)(a[13 * i + 1] & 0xFF) & 0x1F) << 8);
                this.coeffs[8 * i + 1] = (short)((a[13 * i + 1] & 0xFF) >>> 5 | (short)(a[13 * i + 2] & 0xFF) << 3 | ((short)(a[13 * i + 3] & 0xFF) & 3) << 11);
                this.coeffs[8 * i + 2] = (short)((a[13 * i + 3] & 0xFF) >>> 2 | ((short)(a[13 * i + 4] & 0xFF) & 0x7F) << 6);
                this.coeffs[8 * i + 3] = (short)((a[13 * i + 4] & 0xFF) >>> 7 | (short)(a[13 * i + 5] & 0xFF) << 1 | ((short)(a[13 * i + 6] & 0xFF) & 0xF) << 9);
                break;
            }
            case 2: {
                this.coeffs[8 * i + 0] = (short)(a[13 * i + 0] & 0xFF | ((short)(a[13 * i + 1] & 0xFF) & 0x1F) << 8);
                this.coeffs[8 * i + 1] = (short)((a[13 * i + 1] & 0xFF) >>> 5 | (short)(a[13 * i + 2] & 0xFF) << 3 | ((short)(a[13 * i + 3] & 0xFF) & 3) << 11);
            }
        }
        this.coeffs[this.params.n() - 1] = 0;
    }

    @Override
    public void lift(Polynomial a) {
        int i;
        int n = this.coeffs.length;
        Polynomial b = this.params.createPolynomial();
        short t = (short)(3 - n % 3);
        b.coeffs[0] = (short)(a.coeffs[0] * (2 - t) + a.coeffs[1] * 0 + a.coeffs[2] * t);
        b.coeffs[1] = (short)(a.coeffs[1] * (2 - t) + a.coeffs[2] * 0);
        b.coeffs[2] = (short)(a.coeffs[2] * (2 - t));
        short zj = 0;
        for (i = 3; i < n; ++i) {
            b.coeffs[0] = (short)(b.coeffs[0] + a.coeffs[i] * (zj + 2 * t));
            b.coeffs[1] = (short)(b.coeffs[1] + a.coeffs[i] * (zj + t));
            b.coeffs[2] = (short)(b.coeffs[2] + a.coeffs[i] * zj);
            zj = (short)((zj + t) % 3);
        }
        b.coeffs[1] = (short)(b.coeffs[1] + a.coeffs[0] * (zj + t));
        b.coeffs[2] = (short)(b.coeffs[2] + a.coeffs[0] * zj);
        b.coeffs[2] = (short)(b.coeffs[2] + a.coeffs[1] * (zj + t));
        for (i = 3; i < n; ++i) {
            b.coeffs[i] = (short)(b.coeffs[i - 3] + 2 * (a.coeffs[i] + a.coeffs[i - 1] + a.coeffs[i - 2]));
        }
        b.mod3PhiN();
        b.z3ToZq();
        this.coeffs[0] = -b.coeffs[0];
        for (i = 0; i < n - 1; ++i) {
            this.coeffs[i + 1] = (short)(b.coeffs[i] - b.coeffs[i + 1]);
        }
    }
}

