/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.cryptography.mail.protect;

import jakarta.mail.BodyPart;
import jakarta.mail.Message;
import jakarta.mail.MessagingException;
import jakarta.mail.Multipart;
import jakarta.mail.Part;
import jakarta.mail.internet.MimeBodyPart;
import jakarta.mail.internet.MimeMessage;
import jakarta.mail.internet.MimeMultipart;
import java.io.IOException;
import net.savignano.cryptography.mail.protect.ProtectedHeadersMailHeaderProtector;
import net.savignano.cryptography.util.MessageUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LegacyMailHeaderProtector
extends ProtectedHeadersMailHeaderProtector {
    private static final Logger log = LoggerFactory.getLogger(LegacyMailHeaderProtector.class);

    @Override
    public void protectHeaders(MimeMessage msg) throws IOException, MessagingException {
        log.info("Adding legacy part to message with ID {}.", (Object)MessageUtil.getMessageId((Message)msg));
        MimeBodyPart legacyPart = new MimeBodyPart();
        legacyPart.setDisposition("inline");
        legacyPart.setText("Subject: " + msg.getSubject() + "\n\n", "UTF-8", "plain; protected-headers=\"v1\"");
        legacyPart.setHeader("Content-Transfer-Encoding", "quoted-printable");
        MimeBodyPart contentPart = new MimeBodyPart();
        MessageUtil.movePart((Part)msg, (Part)contentPart);
        MimeMultipart mp = new MimeMultipart();
        mp.addBodyPart((BodyPart)legacyPart);
        mp.addBodyPart((BodyPart)contentPart);
        msg.setContent((Multipart)mp);
        msg.saveChanges();
        super.protectHeaders(msg);
    }
}

