/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.atlassian.common.security.access.smime;

import com.atlassian.cache.Cache;
import java.security.cert.X509Certificate;
import net.savignano.cryptography.enums.ECryptographyType;
import net.savignano.cryptography.enums.EKeySource;
import net.savignano.cryptography.enums.EKeyValidity;
import net.savignano.cryptography.key.loader.AKeyLoader;
import net.savignano.cryptography.key.smime.SmimeEncryptionKey;

public class SmimeCacheLoader
extends AKeyLoader<SmimeEncryptionKey, String> {
    private final Cache<String, X509Certificate> cache;

    public SmimeCacheLoader(Cache<String, X509Certificate> cache) {
        this.cache = cache;
        if (cache == null) {
            throw new IllegalArgumentException("Cache must not be null.");
        }
    }

    public void clear(String email) {
        this.cache.remove((Object)email);
    }

    @Override
    public EKeySource getKeySource() {
        return EKeySource.UNKNOWN;
    }

    @Override
    public ECryptographyType getCryptography() {
        return ECryptographyType.SMIME;
    }

    @Override
    protected SmimeEncryptionKey loadInternalKey(String email) throws Exception {
        X509Certificate cert = (X509Certificate)this.cache.get((Object)email);
        return cert == null ? this.getValidityKey(EKeyValidity.NOT_FOUND) : new SmimeEncryptionKey(cert, email);
    }

    @Override
    protected SmimeEncryptionKey getValidityKey(EKeyValidity validity) {
        return new SmimeEncryptionKey(validity, this.getKeySource());
    }
}

