/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.atlassian.gui;

import net.savignano.cryptography.version.IVersion;
import net.savignano.cryptography.version.ProductInformation;
import net.savignano.snotify.atlassian.common.EProperty;
import net.savignano.snotify.atlassian.common.properties.ISnotifyAppProperties;
import org.apache.commons.lang3.StringUtils;

public abstract class AMailerVersion
implements IVersion {
    private static String version;
    private final ISnotifyAppProperties appProps;
    private String atlassianUrl;
    private ProductInformation productInfo;

    public static final void clearCachedVersion() {
        version = null;
    }

    public AMailerVersion(ISnotifyAppProperties appProps) {
        this.appProps = appProps;
        if (appProps == null) {
            throw new IllegalArgumentException("Application Properties must not be null.");
        }
    }

    @Override
    public String getVersion() {
        if (version == null) {
            this.getAppProps().setString(EProperty.MAILER_VERSION, null);
            this.sendInternalMail();
            version = this.getAppProps().getString(EProperty.MAILER_VERSION);
        }
        return version;
    }

    protected abstract void sendInternalMail();

    protected String createHtmlContent() {
        StringBuilder builder = new StringBuilder(2048);
        builder.append("<!DOCTYPE html><html><body>\n");
        builder.append("<p>This is a test email of ");
        builder.append(this.getProductName());
        builder.append(" at ");
        builder.append(this.getAtlassianLink());
        builder.append(".</p>\n");
        builder.append("<p>Should you have received this, the S/Notify mailer library may not be properly configured or missing entirely. Please go to <i>Manage Apps</i>, select <i>S/Notify</i>, and click <i>Get Started</i> to check if there is a problem.</p>\n");
        builder.append("</body></html>");
        return builder.toString();
    }

    protected String createTextContent() {
        return "This is a test email of " + this.getProductName() + " at " + this.getAtlassianLink() + ".\n\nShould you have received this, the S/Notify mailer library may not be properly configured or missing entirely. Please go to Manage Apps, select S/Notify, and click Get Started to check if there is a problem.";
    }

    public String getAtlassianUrl() {
        return this.atlassianUrl;
    }

    public void setAtlassianUrl(String atlassianUrl) {
        this.atlassianUrl = atlassianUrl;
    }

    public ProductInformation getProductInfo() {
        return this.productInfo;
    }

    public void setProductInfo(ProductInformation productInfo) {
        this.productInfo = productInfo;
    }

    protected ISnotifyAppProperties getAppProps() {
        return this.appProps;
    }

    private String getAtlassianLink() {
        if (this.getAtlassianUrl() == null) {
            return "<b>Unknown Atlassian Instance</b>";
        }
        String url = StringUtils.removeEnd((String)this.getAtlassianUrl(), (String)"/");
        return "<a href=\"" + url + "\">" + url + "</a>";
    }

    private String getProductName() {
        if (this.getProductInfo() != null) {
            return this.getProductInfo().getProduct();
        }
        return "S/Notify";
    }
}

