/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.confluence.common;

import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.confluence.user.UserPreferences;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.opensymphony.module.propertyset.PropertyException;
import net.savignano.snotify.atlassian.common.properties.ASnotifyUserProperties;
import net.savignano.snotify.atlassian.common.user.IUser;
import net.savignano.snotify.confluence.common.ConfluenceUser;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SnotifyUserProperties
extends ASnotifyUserProperties {
    @ComponentImport
    private final UserAccessor accessor;

    @Autowired
    public SnotifyUserProperties(UserAccessor accessor) {
        this.accessor = accessor;
    }

    @Override
    protected String get(String key, IUser<?> user) throws Exception {
        return this.getPrefs(user).getString(key).orElse(null);
    }

    @Override
    protected void set(String key, String value, IUser<?> user) throws Exception {
        this.getPrefs(user).setString(key, value);
    }

    @Override
    protected void remove(String key, IUser<?> user) throws Exception {
        this.getPrefs(user).remove(key);
    }

    private UserPreferences getPrefs(IUser<?> user) {
        if (user == null) {
            throw new PropertyException("Can't get user preferences for 'null' user.");
        }
        if (!(user instanceof ConfluenceUser)) {
            throw new PropertyException("User is not a ConfluenceUser. Found instead: " + String.valueOf(user));
        }
        return this.accessor.getUserPreferences(((ConfluenceUser)user).getAsConfluenceUser());
    }
}

