/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.confluence.gui.action;

import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.sal.api.component.ComponentLocator;
import com.atlassian.user.EntityException;
import com.atlassian.user.GroupManager;
import com.atlassian.user.search.page.Pager;
import jakarta.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.savignano.snotify.atlassian.common.EProperty;
import net.savignano.snotify.atlassian.gui.templates.handler.IValueHandler;
import net.savignano.snotify.atlassian.gui.templates.handler.IValueHandlerProvider;
import net.savignano.snotify.atlassian.gui.templates.handler.impl.CheckBoxHandler;
import net.savignano.snotify.atlassian.gui.templates.handler.impl.EnumHandler;
import net.savignano.snotify.atlassian.gui.templates.handler.impl.provider.ValueHandlerContainer;
import net.savignano.snotify.confluence.gui.action.SnotifyAdminSettingsAction;
import org.apache.commons.lang3.StringUtils;

public class SnotifyGlobalSettingsAction
extends SnotifyAdminSettingsAction
implements IValueHandlerProvider {
    private static final long serialVersionUID = 1520021057323526638L;
    private static final String WHITELIST_USER_GROUP_PARAM = "whitelistUserGroup";
    private static final String ENCRYPTION_FAILURE_ID = "encryptionFailure";
    private static final String ENCRYPTION_TYPE_PRIORITY_ID = "encryptionTypePriority";
    private static final String PROJECT_SPECIFIC_ENCRYPTION_ID = "projectSpecificEncryption";
    private static final String DEFAULT_PROJECT_ENCRYPTION_ID = "defaultProjectEncryption";
    private static final String AMBIGUOUS_PROJECT_ENCRYPTION_ID = "ambiguousProjectEncryption";
    private static final String NO_PROJECT_ENCRYPTION_ID = "noProjectEncryption";
    private static final String SIGNING_ENABLED_ID = "signingEnabled";
    private static final String SIGNING_SMIME_OPAQUE_ID = "signingSmimeOpaque";
    private static final String SUBJECT_REPLACEMENT_ID = "subjectReplacement";
    private static final String SUBJECT_REPLACEMENT_KEEP_ID_ID = "subjectReplacementKeepId";
    private static final String REPORT_SHOWS_LINK_ID = "reportShowsLink";
    private static final String ALLOW_PASSWORD_RESET_MAIL_ID = "allowPasswordResetMail";
    private ValueHandlerContainer valueContainer;
    private String whitelistUserGroup;

    public String doInput() {
        if (!this.hasAdminRights()) {
            ConfluenceUser user = this.getAuthenticatedUser();
            this.getLog().warn("Unauthorized access to view global S/Notify values from user: {}", (Object)(user != null ? user.getFullName() : "<Unknown User>"));
            return "error";
        }
        this.createValueHandlers();
        this.valueContainer.read();
        this.whitelistUserGroup = this.getAppProps().getString(EProperty.WHITELIST_USER_GROUP);
        return "input";
    }

    public String doSubmit() {
        HttpServletRequest request = this.getActiveRequest();
        if (!"POST".equals(request.getMethod())) {
            this.getLog().debug("Access to submit method redirected to input method, as request method wasn't 'POST'. Used method: " + request.getMethod());
            return this.doInput();
        }
        if (!this.hasAdminRights()) {
            ConfluenceUser user = this.getAuthenticatedUser();
            this.getLog().warn("Unauthorized access to submit global S/Notify values from user: {}", (Object)(user != null ? user.getFullName() : "<Unknown User>"));
            return "error";
        }
        this.createValueHandlers();
        this.valueContainer.receive(request);
        this.valueContainer.store();
        this.whitelistUserGroup = request.getParameter(WHITELIST_USER_GROUP_PARAM);
        this.getAppProps().setString(EProperty.WHITELIST_USER_GROUP, StringUtils.isEmpty((CharSequence)this.whitelistUserGroup) ? null : this.whitelistUserGroup);
        this.setShowUpdated(true);
        return "success";
    }

    private void createValueHandlers() {
        if (this.valueContainer != null) {
            return;
        }
        this.valueContainer = new ValueHandlerContainer();
        this.valueContainer.add(new EnumHandler(ENCRYPTION_TYPE_PRIORITY_ID, this.getAppProps(), EProperty.ENCRYPTION_TYPE_PRIORITY));
        this.valueContainer.add(new EnumHandler(ENCRYPTION_FAILURE_ID, this.getAppProps(), EProperty.ENCRYPTION_FAILURE_BEHAVIOR));
        this.valueContainer.add(new CheckBoxHandler(PROJECT_SPECIFIC_ENCRYPTION_ID, this.getAppProps(), EProperty.ENABLE_PROJECT_SPECIFIC_ENCRYPTION));
        this.valueContainer.add(new CheckBoxHandler(DEFAULT_PROJECT_ENCRYPTION_ID, this.getAppProps(), EProperty.DEFAULT_PROJECT_ENCRYPTION_STATE));
        this.valueContainer.add(new CheckBoxHandler(AMBIGUOUS_PROJECT_ENCRYPTION_ID, this.getAppProps(), EProperty.AMBIGUOUS_PROJECT_ENCRYPTION_STATE));
        this.valueContainer.add(new CheckBoxHandler(NO_PROJECT_ENCRYPTION_ID, this.getAppProps(), EProperty.NO_PROJECT_ENCRYPTION_STATE));
        this.valueContainer.add(new CheckBoxHandler(SIGNING_ENABLED_ID, this.getAppProps(), EProperty.SIGNING_ENABLED));
        this.valueContainer.add(new CheckBoxHandler(SIGNING_SMIME_OPAQUE_ID, this.getAppProps(), EProperty.SIGNING_SMIME_OPAQUE));
        this.valueContainer.add(new CheckBoxHandler(SUBJECT_REPLACEMENT_ID, this.getAppProps(), EProperty.SUBJECT_PROTECTION));
        this.valueContainer.add(new CheckBoxHandler(SUBJECT_REPLACEMENT_KEEP_ID_ID, this.getAppProps(), EProperty.SUBJECT_PROTECTION_KEEP_ID));
        this.valueContainer.add(new CheckBoxHandler(REPORT_SHOWS_LINK_ID, this.getAppProps(), EProperty.REPORT_MESSAGE_SHOW_LINK));
        this.valueContainer.add(new CheckBoxHandler(ALLOW_PASSWORD_RESET_MAIL_ID, this.getAppProps(), EProperty.ALLOW_PASSWORD_RESET_MAIL));
    }

    @Override
    public <T extends IValueHandler<?>> T getValueHandler(String id) {
        return this.valueContainer.getValueHandler(id);
    }

    public List<String> getUserGroups() {
        ArrayList<String> userGroups = new ArrayList<String>();
        try {
            Pager groups = ((GroupManager)ComponentLocator.getComponent(GroupManager.class)).getGroups();
            groups.forEach(g -> userGroups.add(g.getName()));
        }
        catch (EntityException e) {
            this.getLog().error("Could not create list of all groups. Error message: " + e.getMessage(), (Throwable)e);
        }
        return userGroups;
    }

    public boolean isGroupSelected(String group) {
        return Objects.equals(StringUtils.trimToNull((String)group), this.whitelistUserGroup);
    }
}

