/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.confluence.gui.action;

import com.atlassian.confluence.spaces.actions.SpaceAdminAction;
import net.savignano.snotify.atlassian.common.EProperty;
import net.savignano.snotify.atlassian.common.properties.ISnotifyAppProperties;
import net.savignano.snotify.atlassian.common.properties.ISnotifyProjectProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class SnotifySpaceSettingsAction
extends SpaceAdminAction {
    private static final long serialVersionUID = -3999083937119472263L;
    private static final Logger log = LoggerFactory.getLogger(SnotifySpaceSettingsAction.class);
    private static final String SPACE_KEY_PARAM = "key";
    private static final String ENCRYPTION_ENABLED_PARAM = "encryptionEnabled";
    private static final String CHECKBOX_CHECKED = "checked=\"checked\"";
    private ISnotifyAppProperties appProps;
    private ISnotifyProjectProperties spaceProps;
    private boolean showUpdated;
    private boolean noXsrfViolation;

    public String doInput() {
        this.noXsrfViolation = true;
        return "input";
    }

    public String doSubmit() {
        this.noXsrfViolation = true;
        if (!"POST".equals(this.getActiveRequest().getMethod())) {
            log.debug("Access to submit method redirected to input method, as request method wasn't 'POST'. Used method: " + this.getActiveRequest().getMethod());
            return this.doInput();
        }
        String encryptionEnabled = this.getActiveRequest().getParameter(ENCRYPTION_ENABLED_PARAM);
        this.getSpaceProps().setBoolean(EProperty.PROJECT_ENABLE_ENCRYPTION, encryptionEnabled != null, this.getActiveRequest().getParameter(SPACE_KEY_PARAM));
        this.showUpdated = true;
        return "input";
    }

    public boolean isShowUpdated() {
        return this.showUpdated;
    }

    public boolean isDisabled() {
        return this.getAppProps().getBoolean(EProperty.DISABLE_SNOTIFY);
    }

    public boolean isFrozen() {
        return this.getAppProps().getBoolean(EProperty.FREEZE_SNOTIFY);
    }

    public String getCheckedEncryptionEnabled() {
        boolean defaultEncryption = this.getAppProps().getBoolean(EProperty.DEFAULT_PROJECT_ENCRYPTION_STATE);
        boolean checked = this.getSpaceProps().getBoolean(EProperty.PROJECT_ENABLE_ENCRYPTION, defaultEncryption, this.getActiveRequest().getParameter(SPACE_KEY_PARAM));
        return checked ? CHECKBOX_CHECKED : "";
    }

    public boolean isSpaceSpecificEncryptionAllowed() {
        return this.getAppProps().getBoolean(EProperty.ENABLE_PROJECT_SPECIFIC_ENCRYPTION);
    }

    public boolean isXsrfViolation() {
        return !this.noXsrfViolation;
    }

    public ISnotifyAppProperties getAppProps() {
        return this.appProps;
    }

    @Autowired
    public void setAppProps(ISnotifyAppProperties appProps) {
        this.appProps = appProps;
    }

    public ISnotifyProjectProperties getSpaceProps() {
        return this.spaceProps;
    }

    @Autowired
    public void setSpaceProps(ISnotifyProjectProperties spaceProps) {
        this.spaceProps = spaceProps;
    }
}

