/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.confluence.gui.action;

import com.atlassian.confluence.api.service.exceptions.ReadOnlyException;
import com.atlassian.confluence.languages.LocaleManager;
import com.atlassian.confluence.user.actions.AbstractUserProfileAction;
import com.atlassian.sal.api.component.ComponentLocator;
import com.atlassian.struts.multipart.FileUploadException;
import com.atlassian.struts.multipart.UploadedFile;
import com.atlassian.user.User;
import com.atlassian.velocity.htmlsafe.HtmlSafe;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.security.InvalidKeyException;
import java.security.KeyException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.Locale;
import net.savignano.cryptography.enums.ECryptographyType;
import net.savignano.cryptography.enums.EKeyPurpose;
import net.savignano.cryptography.enums.EKeySource;
import net.savignano.cryptography.key.pgp.PgpEncryptionKey;
import net.savignano.cryptography.util.PgpUtil;
import net.savignano.cryptography.util.SmimeUtil;
import net.savignano.snotify.atlassian.common.EProperty;
import net.savignano.snotify.atlassian.common.ISnotifyI18n;
import net.savignano.snotify.atlassian.common.enums.EEncryptionTypePriority;
import net.savignano.snotify.atlassian.common.properties.ISnotifyAppProperties;
import net.savignano.snotify.atlassian.common.properties.ISnotifyUserProperties;
import net.savignano.snotify.atlassian.gui.key.info.PgpPublicKeyInfoBuilder;
import net.savignano.snotify.atlassian.gui.key.info.SmimeCertInfoBuilder;
import net.savignano.snotify.confluence.common.ConfluenceUser;
import net.savignano.snotify.confluence.common.SnotifyI18n;
import net.savignano.snotify.confluence.gui.key.info.HtmlKeyValueStyle;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPException;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPPublicKeyRing;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPPublicKeyRingCollection;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class SnotifyUserSettingsAction
extends AbstractUserProfileAction {
    private static final long serialVersionUID = 5056362981557712274L;
    private static final String ERROR_EMAIL_MISMATCH = "error-email";
    private static final String ERROR_ENCRYPTION = "error-encryption";
    private static final String ERROR_EXPIRED = "error-expired";
    private static final String ERROR_KEYNOTFOUND = "error-keynotfound";
    private static final String ERROR_NOFILE = "error-nofile";
    private static final String ERROR_NOTYETVALID = "error-notyetvalid";
    private static final String ERROR_PGP = "error-pgp";
    private static final String ERROR_SMIME = "error-smime";
    private static final String DELETE_BUTTON_PARAM = "Delete";
    private static final Logger log = LoggerFactory.getLogger(SnotifyUserSettingsAction.class);
    private ISnotifyAppProperties appProps;
    private ISnotifyUserProperties userProps;
    private ISnotifyI18n i18n;
    private Exception lastException;
    private EEncryptionTypePriority typePriority;
    private ECryptographyType lastUpload;
    private Boolean allowSmimeUpload;
    private Boolean allowPgpUpload;

    public String doInput() {
        com.atlassian.confluence.user.ConfluenceUser user = this.getAuthenticatedUser();
        if (user == null) {
            return null;
        }
        this.lastUpload = null;
        return "input";
    }

    public String doSubmitSmime() {
        byte[] certData;
        if (!"POST".equals(this.getActiveRequest().getMethod())) {
            log.debug("Access to submit method redirected to input method, as request method wasn't 'POST'. Used method: " + this.getActiveRequest().getMethod());
            return this.doInput();
        }
        com.atlassian.confluence.user.ConfluenceUser authUser = this.getAuthenticatedUser();
        if (authUser == null) {
            log.warn("User is not authenticated for uploading custom S/MIME certificate.");
            return null;
        }
        if (!this.isAllowSmimeUpload()) {
            log.warn("Uploading of custom S/MIME certificate is not allowed. User: {}", (Object)authUser);
            return this.doInput();
        }
        if (this.isReadOnlyMode()) {
            throw new ReadOnlyException(this.i18NBeanFactory.getI18NBean().getText("read.only.mode.default.banner.message"));
        }
        this.lastUpload = ECryptographyType.SMIME;
        if (this.getActiveRequest().getParameterMap().containsKey(DELETE_BUTTON_PARAM)) {
            certData = null;
        } else {
            try {
                certData = this.readUploadedFile();
                if (certData == null || certData.length == 0) {
                    return ERROR_NOFILE;
                }
            }
            catch (IOException e) {
                this.lastException = e;
                log.info("Uploaded file could not be read.", (Throwable)e);
                return "error";
            }
        }
        ConfluenceUser user = new ConfluenceUser((User)authUser);
        try {
            this.setEmailCert(certData, user);
            return "success";
        }
        catch (EmailException e) {
            this.lastException = e;
            log.info("Email address mismatch.", (Throwable)e);
            return ERROR_EMAIL_MISMATCH;
        }
        catch (KeyException e) {
            this.lastException = e;
            log.info("Certificate not useable for encryption.", (Throwable)e);
            return ERROR_ENCRYPTION;
        }
        catch (CertificateExpiredException e) {
            this.lastException = e;
            log.info("Certificate expired.", (Throwable)e);
            return ERROR_EXPIRED;
        }
        catch (CertificateNotYetValidException e) {
            this.lastException = e;
            log.info("Certificate not yet valid.", (Throwable)e);
            return ERROR_NOTYETVALID;
        }
        catch (CertificateException e) {
            this.lastException = e;
            log.info("Certificate parsing failed.", (Throwable)e);
            return ERROR_SMIME;
        }
    }

    public String doSubmitPgp() {
        byte[] keyData;
        if (!"POST".equals(this.getActiveRequest().getMethod())) {
            log.debug("Access to submit method redirected to input method, as request method wasn't 'POST'. Used method: " + this.getActiveRequest().getMethod());
            return this.doInput();
        }
        com.atlassian.confluence.user.ConfluenceUser authUser = this.getAuthenticatedUser();
        if (authUser == null) {
            log.warn("User is not authenticated for uploading custom PGP key.");
            return null;
        }
        if (!this.isAllowPgpUpload()) {
            log.warn("Uploading of custom PGP key is not allowed. User: {}", (Object)authUser);
            return null;
        }
        if (this.isReadOnlyMode()) {
            throw new ReadOnlyException(this.i18NBeanFactory.getI18NBean().getText("read.only.mode.default.banner.message"));
        }
        this.lastUpload = ECryptographyType.PGP;
        if (this.getActiveRequest().getParameterMap().containsKey(DELETE_BUTTON_PARAM)) {
            keyData = null;
        } else {
            try {
                keyData = this.readUploadedFile();
                if (keyData == null || keyData.length == 0) {
                    return ERROR_NOFILE;
                }
            }
            catch (IOException e) {
                this.lastException = e;
                log.info("Uploaded file could not be read.", (Throwable)e);
                return "error";
            }
        }
        ConfluenceUser user = new ConfluenceUser((User)this.getUser());
        try {
            this.setEmailPgpKey(keyData, user);
            return "success";
        }
        catch (PGPException e) {
            this.lastException = e;
            log.info("Key parsing failed.", (Throwable)e);
            return ERROR_PGP;
        }
        catch (KeyException e) {
            this.lastException = e;
            log.info("No valid key found.", (Throwable)e);
            return ERROR_KEYNOTFOUND;
        }
    }

    private byte[] readUploadedFile() throws IOException {
        UploadedFile uploadedFile;
        try {
            uploadedFile = this.strutsHelper.getUploadedFile(this.getActiveRequest(), "file");
        }
        catch (FileUploadException e) {
            throw new IOException(e.getMessage(), e);
        }
        if (uploadedFile == null) {
            return null;
        }
        return Files.readAllBytes(uploadedFile.getFile().toPath());
    }

    private void setEmailCert(byte[] cert, ConfluenceUser user) throws CertificateException, KeyException {
        if (cert == null || cert.length == 0) {
            log.debug("Clearing certificate for user: " + user.getDisplayName());
            this.userProps.setBytes(EProperty.EMAIL_SMIME_CERT, null, user);
            this.userProps.setLong(EProperty.EMAIL_SMIME_TIME_STAMP, null, user);
            this.userProps.setEnum(EProperty.EMAIL_SMIME_KEY_SOURCE, null, user);
        } else {
            log.debug("Checking certificate for user: " + user.getDisplayName());
            this.checkSmimeCert(cert, user);
            log.debug("Setting certificate for user: " + user.getDisplayName());
            this.userProps.setBytes(EProperty.EMAIL_SMIME_CERT, cert, user);
            this.userProps.setLong(EProperty.EMAIL_SMIME_TIME_STAMP, System.currentTimeMillis(), user);
            this.userProps.setEnum(EProperty.EMAIL_SMIME_KEY_SOURCE, EKeySource.USER, user);
        }
    }

    private void checkSmimeCert(byte[] cert, ConfluenceUser user) throws CertificateException, KeyException {
        CertificateFactory fact = CertificateFactory.getInstance("X.509");
        X509Certificate certificate = (X509Certificate)fact.generateCertificate(new ByteArrayInputStream(cert));
        certificate.checkValidity();
        String certEmail = StringUtils.join((Object[])SmimeUtil.getEmails(certificate), (String)", ").toLowerCase();
        if (!certEmail.contains(user.getEmail().toLowerCase())) {
            throw new EmailException(StringEscapeUtils.escapeHtml4((String)certEmail), user.getDisplayName());
        }
        if (!SmimeUtil.isCertForPurpose(certificate, EKeyPurpose.ENCRYPTION)) {
            throw new InvalidKeyException("Certificate is not useable for encryption.");
        }
    }

    private void setEmailPgpKey(byte[] key, ConfluenceUser user) throws PGPException, KeyException {
        ISnotifyUserProperties userProps = this.getUserProps();
        if (key == null || key.length == 0) {
            log.info("Clearing PGP key for user: {}", (Object)user.getDisplayName());
            userProps.setBytes(EProperty.EMAIL_PGP_KEY, null, user);
            userProps.setLong(EProperty.EMAIL_PGP_KEY_ID, null, user);
            userProps.setLong(EProperty.EMAIL_PGP_TIME_STAMP, null, user);
            userProps.setEnum(EProperty.EMAIL_PGP_KEY_SOURCE, null, user);
        } else {
            log.debug("Checking PGP key for user: {}", (Object)user.getDisplayName());
            PgpEncryptionKey pubKey = this.loadPgpKey(key, user);
            log.info("Setting PGP key for user: {}", (Object)user.getDisplayName());
            userProps.setBytes(EProperty.EMAIL_PGP_KEY, key, user);
            userProps.setLong(EProperty.EMAIL_PGP_KEY_ID, pubKey.getKey().getKeyID(), user);
            userProps.setLong(EProperty.EMAIL_PGP_TIME_STAMP, System.currentTimeMillis(), user);
            userProps.setEnum(EProperty.EMAIL_PGP_KEY_SOURCE, EKeySource.USER, user);
        }
    }

    private PgpEncryptionKey loadPgpKey(byte[] key, ConfluenceUser user) throws PGPException, KeyException {
        PGPPublicKeyRingCollection keyRings;
        String userEmailAddress = user.getEmail().toLowerCase();
        try {
            keyRings = PgpUtil.loadPublicKeys(new ByteArrayInputStream(key));
        }
        catch (IOException e) {
            throw new KeyException("Could not read stream", e);
        }
        PGPPublicKeyRing keyRing = PgpUtil.getKeysForEmail(keyRings, userEmailAddress);
        if (keyRing == null) {
            throw new KeyException("Could not find a key ring for email address: " + userEmailAddress);
        }
        PgpEncryptionKey pubKey = new PgpEncryptionKey(keyRing, userEmailAddress);
        if (!pubKey.isValid()) {
            throw new KeyException("Could not find a valid encryption key.");
        }
        return pubKey;
    }

    private String buildCertInfo(byte[] cert, ConfluenceUser user) throws CertificateException {
        SmimeCertInfoBuilder builder = new SmimeCertInfoBuilder(cert, this.getSnotifyI18n());
        builder.setUser(user);
        builder.setUserProps(this.getUserProps());
        return builder.build(new HtmlKeyValueStyle());
    }

    private String buildKeyInfo(byte[] key, long keyId, ConfluenceUser user) throws IOException, PGPException {
        PgpPublicKeyInfoBuilder builder = new PgpPublicKeyInfoBuilder(key, keyId, this.getSnotifyI18n());
        builder.setUser(user);
        builder.setUserProps(this.getUserProps());
        return builder.build(new HtmlKeyValueStyle());
    }

    public ISnotifyAppProperties getAppProps() {
        return this.appProps;
    }

    @Autowired
    public void setAppProps(ISnotifyAppProperties appProps) {
        this.appProps = appProps;
    }

    public ISnotifyUserProperties getUserProps() {
        return this.userProps;
    }

    @Autowired
    public void setUserProps(ISnotifyUserProperties userProps) {
        this.userProps = userProps;
    }

    private ISnotifyI18n getSnotifyI18n() {
        if (this.i18n == null) {
            LocaleManager localeManager = (LocaleManager)ComponentLocator.getComponent(LocaleManager.class);
            Locale locale = localeManager.getLocale((User)this.getAuthenticatedUser());
            this.i18n = new SnotifyI18n(this.getI18n(), locale);
        }
        return this.i18n;
    }

    public String getErrorMessage() {
        return this.lastException == null ? null : this.lastException.getMessage();
    }

    @HtmlSafe
    public String getCertDetails() {
        ConfluenceUser user = new ConfluenceUser((User)this.getUser());
        Object cert = this.getAppProps().getBoolean(EProperty.LITE_MODE) && this.getUserProps().getEnum(EProperty.EMAIL_SMIME_KEY_SOURCE, EKeySource.class, user) != EKeySource.USER ? null : this.getUserProps().getBytes(EProperty.EMAIL_SMIME_CERT, user);
        String info = null;
        if (cert == null) {
            info = this.getText("snotify-user-settings-webwork.input.smime.notfound");
            log.debug("No S/MIME certificate specified for user: {}", (Object)user.getDisplayName());
        } else {
            try {
                info = this.buildCertInfo((byte[])cert, user);
                log.debug("Certificate information for user {}: {}", (Object)user.getDisplayName(), (Object)info);
            }
            catch (CertificateException e) {
                log.warn("Could not load S/MIME certificate for user: " + user.getDisplayName(), (Throwable)e);
                info = this.getText("snotify-user-settings-webwork.input.smime.error", new String[]{e.getLocalizedMessage()});
            }
        }
        return info;
    }

    @HtmlSafe
    public String getPgpDetails() {
        Long keyId;
        byte[] key;
        ConfluenceUser user = new ConfluenceUser((User)this.getUser());
        if (this.getAppProps().getBoolean(EProperty.LITE_MODE) && this.getUserProps().getEnum(EProperty.EMAIL_PGP_KEY_SOURCE, EKeySource.class, user) != EKeySource.USER) {
            key = null;
            keyId = null;
        } else {
            key = this.getUserProps().getBytes(EProperty.EMAIL_PGP_KEY, user);
            keyId = this.getUserProps().getLong(EProperty.EMAIL_PGP_KEY_ID, user);
        }
        String info = null;
        if (key == null || keyId == null) {
            info = this.getText("snotify-user-settings-webwork.input.pgp.notfound");
            log.debug("No PGP key specified for user: {}", (Object)user.getDisplayName());
        } else {
            try {
                info = this.buildKeyInfo(key, keyId, user);
                log.debug("Key information for user {}: {}", (Object)user.getDisplayName(), (Object)info);
            }
            catch (IOException | PGPException e) {
                log.warn("Could not load PGP key for user: " + user.getDisplayName(), (Throwable)e);
                info = this.getText("snotify-user-settings-webwork.input.pgp.error", e.getLocalizedMessage());
            }
        }
        return info;
    }

    public boolean isChoiceEnabled() {
        switch (this.getTypePriority()) {
            case SMIME_PREFERRED: 
            case PGP_PREFERRED: {
                return true;
            }
            case SMIME_ONLY: 
            case PGP_ONLY: {
                return false;
            }
        }
        log.warn("Unknwon value for 'Encryption Type Priority' found. Value found was '" + String.valueOf((Object)this.getTypePriority()) + "'. It is not yet implemented,");
        return true;
    }

    public boolean isSmimeSelected() {
        if (this.lastUpload == ECryptographyType.SMIME) {
            return true;
        }
        if (this.lastUpload == ECryptographyType.PGP) {
            return false;
        }
        switch (this.getTypePriority()) {
            case SMIME_ONLY: {
                return true;
            }
            case PGP_ONLY: {
                return false;
            }
            case SMIME_PREFERRED: {
                return this.isAllowSmimeUpload() || !this.isAllowPgpUpload();
            }
            case PGP_PREFERRED: {
                return this.isAllowSmimeUpload() && !this.isAllowPgpUpload();
            }
        }
        log.warn("Unknwon value for 'Encryption Type Priority' found. Value found was '" + String.valueOf((Object)this.getTypePriority()) + "'. It is not yet implemented,");
        return true;
    }

    public boolean isPgpSelected() {
        if (this.lastUpload == ECryptographyType.PGP) {
            return true;
        }
        if (this.lastUpload == ECryptographyType.SMIME) {
            return false;
        }
        switch (this.getTypePriority()) {
            case SMIME_ONLY: {
                return false;
            }
            case PGP_ONLY: {
                return true;
            }
            case SMIME_PREFERRED: {
                return this.isAllowPgpUpload() && !this.isAllowSmimeUpload();
            }
            case PGP_PREFERRED: {
                return this.isAllowPgpUpload() || !this.isAllowSmimeUpload();
            }
        }
        log.warn("Unknwon value for 'Encryption Type Priority' found. Value found was '" + String.valueOf((Object)this.getTypePriority()) + "'. It is not yet implemented,");
        return false;
    }

    public boolean isSmimeUploadAllowed() {
        return this.isAllowSmimeUpload() && (this.isChoiceEnabled() || this.isSmimeSelected()) && !this.isReadOnlyMode();
    }

    public boolean isPgpUploadAllowed() {
        return this.isAllowPgpUpload() && (this.isChoiceEnabled() || this.isPgpSelected()) && !this.isReadOnlyMode();
    }

    public boolean showMultipleUsersError() {
        return (this.isAllowSmimeUpload() || this.isAllowPgpUpload()) && ConfluenceUser.lookupUsers(this.getAuthenticatedUser().getEmail()).size() > 1;
    }

    private EEncryptionTypePriority getTypePriority() {
        if (this.typePriority == null) {
            this.typePriority = this.getAppProps().getEnum(EProperty.ENCRYPTION_TYPE_PRIORITY, EEncryptionTypePriority.class);
        }
        return this.typePriority;
    }

    private boolean isReadOnlyMode() {
        return this.accessModeService.isReadOnlyAccessModeEnabled();
    }

    private boolean isAllowSmimeUpload() {
        if (this.allowSmimeUpload == null) {
            this.allowSmimeUpload = this.getAppProps().getBoolean(EProperty.ALLOW_SMIME_CERTIFICATE_OVERWRITE) || this.getAppProps().getBoolean(EProperty.LITE_MODE);
        }
        return this.allowSmimeUpload;
    }

    private boolean isAllowPgpUpload() {
        if (this.allowPgpUpload == null) {
            this.allowPgpUpload = this.getAppProps().getBoolean(EProperty.ALLOW_PGP_PUBLIC_KEY_OVERWRITE) || this.getAppProps().getBoolean(EProperty.LITE_MODE);
        }
        return this.allowPgpUpload;
    }

    private static final class EmailException
    extends CertificateException {
        private static final long serialVersionUID = -5262905856665194L;

        private EmailException(String email, String user) {
            super("Email address(es) of certificate (" + email + ") does not match email of user: " + user);
        }
    }
}

