/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.gpg.keybox;

import java.io.IOException;
import net.savignano.thirdparty.org.bouncycastle.gpg.keybox.BlobType;
import net.savignano.thirdparty.org.bouncycastle.gpg.keybox.BlobVerifier;
import net.savignano.thirdparty.org.bouncycastle.gpg.keybox.CertificateBlob;
import net.savignano.thirdparty.org.bouncycastle.gpg.keybox.FirstBlob;
import net.savignano.thirdparty.org.bouncycastle.gpg.keybox.KeyBoxByteBuffer;
import net.savignano.thirdparty.org.bouncycastle.gpg.keybox.PublicKeyRingBlob;
import net.savignano.thirdparty.org.bouncycastle.openpgp.operator.KeyFingerPrintCalculator;
import net.savignano.thirdparty.org.bouncycastle.util.Strings;

public class Blob {
    protected static final byte[] magicBytes = Strings.toByteArray("KBXf");
    protected final int base;
    protected final long length;
    protected final BlobType type;
    protected final int version;

    protected Blob(int base, long length, BlobType type, int version) {
        this.base = base;
        this.length = length;
        this.type = type;
        this.version = version;
    }

    static Blob getInstance(Object source, KeyFingerPrintCalculator keyFingerPrintCalculator, BlobVerifier blobVerifier) throws IOException {
        if (source == null) {
            throw new IllegalArgumentException("Cannot take get instance of null");
        }
        KeyBoxByteBuffer buffer = KeyBoxByteBuffer.wrap(source);
        if (!buffer.hasRemaining()) {
            return null;
        }
        int base = buffer.position();
        long len = buffer.u32();
        BlobType type = BlobType.fromByte(buffer.u8());
        int version = buffer.u8();
        switch (type) {
            case EMPTY_BLOB: {
                break;
            }
            case FIRST_BLOB: {
                return FirstBlob.parseContent(base, len, type, version, buffer);
            }
            case X509_BLOB: {
                return CertificateBlob.parseContent(base, len, type, version, buffer, blobVerifier);
            }
            case OPEN_PGP_BLOB: {
                return PublicKeyRingBlob.parseContent(base, len, type, version, buffer, keyFingerPrintCalculator, blobVerifier);
            }
        }
        return null;
    }

    public BlobType getType() {
        return this.type;
    }

    public int getVersion() {
        return this.version;
    }
}

