/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.openpgp.examples;

import java.io.FileInputStream;
import java.security.Security;
import java.util.Iterator;
import net.savignano.thirdparty.org.bouncycastle.jce.provider.BouncyCastleProvider;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPPublicKey;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPPublicKeyRing;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPPublicKeyRingCollection;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPUtil;
import net.savignano.thirdparty.org.bouncycastle.openpgp.operator.KeyFingerPrintCalculator;
import net.savignano.thirdparty.org.bouncycastle.openpgp.operator.jcajce.JcaKeyFingerprintCalculator;
import net.savignano.thirdparty.org.bouncycastle.util.encoders.Hex;

public class PubringDump {
    public static String getAlgorithm(int algId) {
        switch (algId) {
            case 1: {
                return "RSA_GENERAL";
            }
            case 2: {
                return "RSA_ENCRYPT";
            }
            case 3: {
                return "RSA_SIGN";
            }
            case 16: {
                return "ELGAMAL_ENCRYPT";
            }
            case 17: {
                return "DSA";
            }
            case 18: {
                return "ECDH";
            }
            case 19: {
                return "ECDSA";
            }
            case 20: {
                return "ELGAMAL_GENERAL";
            }
            case 21: {
                return "DIFFIE_HELLMAN";
            }
        }
        return "unknown";
    }

    public static void main(String[] args) throws Exception {
        Security.addProvider(new BouncyCastleProvider());
        PGPPublicKeyRingCollection pubRings = new PGPPublicKeyRingCollection(PGPUtil.getDecoderStream(new FileInputStream(args[0])), (KeyFingerPrintCalculator)new JcaKeyFingerprintCalculator());
        Iterator<PGPPublicKeyRing> rIt = pubRings.getKeyRings();
        while (rIt.hasNext()) {
            PGPPublicKeyRing pgpPub = rIt.next();
            try {
                pgpPub.getPublicKey();
            }
            catch (Exception e) {
                e.printStackTrace();
                continue;
            }
            Iterator<PGPPublicKey> it = pgpPub.getPublicKeys();
            boolean first = true;
            while (it.hasNext()) {
                PGPPublicKey pgpKey = it.next();
                if (first) {
                    System.out.println("Key ID: " + Long.toHexString(pgpKey.getKeyID()));
                    first = false;
                } else {
                    System.out.println("Key ID: " + Long.toHexString(pgpKey.getKeyID()) + " (subkey)");
                }
                System.out.println("            Algorithm: " + PubringDump.getAlgorithm(pgpKey.getAlgorithm()));
                System.out.println("            Fingerprint: " + new String(Hex.encode(pgpKey.getFingerprint())));
            }
        }
    }
}

