/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.cryptography.key;

import net.savignano.cryptography.enums.ECryptographyType;
import net.savignano.cryptography.enums.EKeyPurpose;
import net.savignano.cryptography.enums.EKeyValidity;
import net.savignano.cryptography.key.ACryptographyKey;
import net.savignano.cryptography.key.IPublicCryptographyKey;
import net.savignano.cryptography.key.ISecretCryptographyKey;

public class ValidityKey<T>
extends ACryptographyKey<T>
implements IPublicCryptographyKey<T>,
ISecretCryptographyKey<T> {
    public static final <T> ValidityKey<T> errorSmimeKey() {
        return ValidityKey.key(EKeyValidity.ERROR, ECryptographyType.SMIME);
    }

    public static final <T> ValidityKey<T> invalidSmimeKey() {
        return ValidityKey.key(EKeyValidity.INVALID, ECryptographyType.SMIME);
    }

    public static final <T> ValidityKey<T> notFoundSmimeKey() {
        return ValidityKey.key(EKeyValidity.NOT_FOUND, ECryptographyType.SMIME);
    }

    public static final <T> ValidityKey<T> errorPgpKey() {
        return ValidityKey.key(EKeyValidity.ERROR, ECryptographyType.PGP);
    }

    public static final <T> ValidityKey<T> invalidPgpKey() {
        return ValidityKey.key(EKeyValidity.INVALID, ECryptographyType.PGP);
    }

    public static final <T> ValidityKey<T> notFoundPgpKey() {
        return ValidityKey.key(EKeyValidity.NOT_FOUND, ECryptographyType.PGP);
    }

    public static final <T> ValidityKey<T> key(EKeyValidity validity, ECryptographyType cryptography) {
        if (validity == null) {
            throw new IllegalArgumentException("Validity must not be null.");
        }
        if (validity == EKeyValidity.VALID) {
            throw new IllegalArgumentException("This method cannot be used to create a valid key.");
        }
        ValidityKey<T> key = new ValidityKey<T>(null, cryptography);
        key.setKeyValidity(validity);
        return key;
    }

    private ValidityKey(EKeyPurpose keyPurpose, ECryptographyType cryptography) {
        super(keyPurpose, cryptography);
    }

    @Override
    public T getKey() {
        return null;
    }
}

