/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.cryptography.key.loader.smime;

import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import net.savignano.cryptography.enums.EKeyPurpose;
import net.savignano.cryptography.enums.EKeySource;
import net.savignano.cryptography.enums.EKeyValidity;
import net.savignano.cryptography.info.InfoData;
import net.savignano.cryptography.key.loader.smime.ASmimeKeyLoader;
import net.savignano.cryptography.key.smime.SmimeEncryptionKey;
import net.savignano.cryptography.util.KeyStoreContentFetcher;
import net.savignano.cryptography.util.SmimeUtil;
import org.slf4j.Logger;

public class SmimeCertificateKeyStoreLoader
extends ASmimeKeyLoader<SmimeEncryptionKey, String> {
    public static final int INFO_NO_KEY_STORE = 200;
    public static final int INFO_NO_EMAIL = 201;
    public static final int INFO_EMAIL_FOUND = 202;
    public static final int INFO_EMAIL_NOT_FOUND = 203;
    private final KeyStore keyStore;

    public SmimeCertificateKeyStoreLoader(KeyStore keyStore) {
        this.keyStore = keyStore;
    }

    @Override
    protected SmimeEncryptionKey loadInternalKey(String email) throws Exception {
        if (this.getKeyStore() == null) {
            this.getInfoDataManager().send(new InfoData(200, new Object[0]));
            throw new IllegalArgumentException("Key Store must not be null.");
        }
        if (email == null) {
            this.getInfoDataManager().send(new InfoData(201, new Object[0]));
            throw new IllegalArgumentException("Email must not be null.");
        }
        Logger log = this.getLog();
        log.info("Looking up valid S/MIME certificate for email <{}> in public key store.", (Object)email);
        SmimeEncryptionKey key = this.toBestKey(this.findValidCertificates(this.getKeyStore(), email), email);
        if (key.getKeyValidity() == EKeyValidity.NOT_FOUND) {
            log.info("Found no valid S/MIME certificate for email <{}> in public key store.", (Object)email);
            this.getInfoDataManager().send(new InfoData(203, email));
        } else {
            log.info("Found valid S/MIME certificate for email <{}> in public key store.", (Object)email);
            log.trace("Found certificate: {}", (Object)key.getKey());
            this.getInfoDataManager().send(new InfoData(202, email));
        }
        return key;
    }

    private Set<X509Certificate> findValidCertificates(KeyStore keyStore, String email) throws KeyStoreException {
        Predicate<X509Certificate> predEmail = SmimeUtil.createPredicateForEmail(email);
        Predicate<X509Certificate> predPurpose = SmimeUtil.createPredicateForPurpose(EKeyPurpose.ENCRYPTION);
        Predicate<X509Certificate> predValidity = SmimeUtil::isCertCurrentlyValid;
        Predicate<X509Certificate> predCriticalExtension = this::isCritExtensionSatisfied;
        KeyStoreContentFetcher fetcher = new KeyStoreContentFetcher(keyStore);
        Set<X509Certificate> certs = fetcher.getCertsFor(predEmail.and(predValidity).and(predPurpose).and(predCriticalExtension));
        fetcher.destroy();
        return certs;
    }

    private SmimeEncryptionKey toBestKey(Collection<X509Certificate> certs, String email) {
        Function<X509Certificate, SmimeEncryptionKey> keyMapper = cert -> {
            SmimeEncryptionKey key = new SmimeEncryptionKey((X509Certificate)cert, email);
            key.setKeySource(this.getKeySource());
            return key;
        };
        return this.findBest(certs.stream().map(keyMapper), SmimeEncryptionKey::getKey);
    }

    @Override
    public EKeySource getKeySource() {
        return EKeySource.KEYSTORE;
    }

    @Override
    protected SmimeEncryptionKey getValidityKey(EKeyValidity validity) {
        return new SmimeEncryptionKey(validity, this.getKeySource());
    }

    public KeyStore getKeyStore() {
        return this.keyStore;
    }

    public String toString() {
        return "SmimeCertificateKeyStoreLoader [keyStore=" + this.keyStore + "]";
    }
}

