/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.cryptography.key.smime;

import java.io.IOException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import net.savignano.cryptography.enums.ECryptographyType;
import net.savignano.cryptography.enums.EKeyPurpose;
import net.savignano.cryptography.enums.EKeySource;
import net.savignano.cryptography.enums.EKeyValidity;
import net.savignano.cryptography.key.ACryptographyKey;
import net.savignano.cryptography.key.IPublicCryptographyKey;
import net.savignano.cryptography.util.SmimeUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmimeEncryptionKey
extends ACryptographyKey<X509Certificate>
implements IPublicCryptographyKey<X509Certificate> {
    private static final Logger log = LoggerFactory.getLogger(SmimeEncryptionKey.class);
    private final X509Certificate certificate;

    public SmimeEncryptionKey(X509Certificate certificate) {
        this(certificate, null);
    }

    public SmimeEncryptionKey(X509Certificate certificate, String email) {
        super(EKeyPurpose.ENCRYPTION, ECryptographyType.SMIME);
        this.certificate = certificate;
        if (certificate == null) {
            log.warn("Certificate key was <null>.");
            this.setKeyValidity(EKeyValidity.INVALID);
            return;
        }
        if (!SmimeUtil.isCertForPurpose(certificate, this.getKeyPurpose())) {
            log.debug("Certificate cannot be used for encryption.");
            this.setKeyValidity(EKeyValidity.INVALID);
        }
        try {
            if (email == null || SmimeUtil.isCertForEmail(certificate, email)) {
                certificate.checkValidity();
            } else {
                log.debug("Email <{}> does not match emails for certificate.", (Object)email);
                this.setKeyValidity(EKeyValidity.INVALID);
            }
        }
        catch (CertificateExpiredException e) {
            log.warn("Certificate with serial number {} is invalid because it expired at: {}", (Object)SmimeUtil.getSerialNumber(certificate), (Object)certificate.getNotAfter());
            this.setKeyValidity(EKeyValidity.INVALID);
        }
        catch (CertificateNotYetValidException e) {
            log.warn("Certificate with serial number {} is invalid because it only becomes valid at: {}", (Object)SmimeUtil.getSerialNumber(certificate), (Object)certificate.getNotBefore());
            this.setKeyValidity(EKeyValidity.INVALID);
        }
        catch (CertificateException e) {
            log.error("Could not check that email <" + email + "> matches certificate with serial number " + SmimeUtil.getSerialNumber(certificate) + ".", (Throwable)e);
            this.setKeyValidity(EKeyValidity.ERROR);
        }
    }

    public SmimeEncryptionKey(EKeyValidity validity) {
        this(validity, EKeySource.UNKNOWN);
    }

    public SmimeEncryptionKey(EKeyValidity validity, EKeySource keySource) {
        super(EKeyPurpose.ENCRYPTION, ECryptographyType.SMIME);
        this.certificate = null;
        this.setKeyValidity(validity);
        this.setKeySource(keySource);
    }

    @Deprecated
    public byte[] getEncoded() throws IOException {
        if (this.certificate == null) {
            return null;
        }
        try {
            return this.certificate.getEncoded();
        }
        catch (CertificateEncodingException e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    @Override
    public X509Certificate getKey() {
        return this.certificate;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder(200);
        builder.append("S/MIME Encryption Key. ");
        builder.append("Key Validity: ");
        builder.append((Object)this.getKeyValidity());
        builder.append("; Key Purpose: ");
        builder.append((Object)this.getKeyPurpose());
        builder.append("; Key Source: ");
        builder.append((Object)this.getKeySource());
        builder.append("; Certificate ID: ");
        builder.append(this.getKey() == null ? null : SmimeUtil.getSerialNumber(this.getKey()));
        return builder.toString();
    }
}

