/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.cryptography.mail.encrypt;

import jakarta.mail.internet.MimeMessage;
import net.savignano.cryptography.enums.ECryptographyType;
import net.savignano.cryptography.mail.BaseCryptographyResult;
import net.savignano.cryptography.mail.encrypt.IEncryptionResult;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1ObjectIdentifier;

public class SmimeEncryptionResult
extends BaseCryptographyResult
implements IEncryptionResult {
    private ASN1ObjectIdentifier symmetricKeyAlgorithm;
    private int symmetricKeySize;

    public SmimeEncryptionResult(MimeMessage msg) {
        super(msg, ECryptographyType.SMIME);
    }

    public ASN1ObjectIdentifier getSymmetricKeyAlgorithm() {
        return this.symmetricKeyAlgorithm;
    }

    public void setSymmetricKeyAlgorithm(ASN1ObjectIdentifier symmetricKeyAlgorithm) {
        this.symmetricKeyAlgorithm = symmetricKeyAlgorithm;
    }

    public int getSymmetricKeySize() {
        return this.symmetricKeySize;
    }

    public void setSymmetricKeySize(int symmetricKeySize) {
        this.symmetricKeySize = symmetricKeySize;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder(super.toString());
        builder.deleteCharAt(builder.length() - 1);
        builder.append(", symmetricKeyAlgorithm=");
        builder.append(this.symmetricKeyAlgorithm);
        builder.append(", symmetricKeySize=");
        builder.append(this.symmetricKeySize);
        builder.append("]");
        return builder.toString();
    }
}

