/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.atlassian.common.security.access.smime;

import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import net.savignano.cryptography.enums.ECryptographyType;
import net.savignano.cryptography.enums.EKeySource;
import net.savignano.cryptography.enums.EKeyValidity;
import net.savignano.cryptography.key.smime.SmimeEncryptionKey;
import net.savignano.cryptography.util.SmimeUtil;
import net.savignano.snotify.atlassian.common.EProperty;
import net.savignano.snotify.atlassian.common.properties.ISnotifyUserProperties;
import net.savignano.snotify.atlassian.common.security.access.AUserKeyLoader;
import net.savignano.snotify.atlassian.common.user.IUser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmimeUserKeyLoader
extends AUserKeyLoader<SmimeEncryptionKey> {
    private static final Logger log = LoggerFactory.getLogger(SmimeUserKeyLoader.class);

    public SmimeUserKeyLoader(ISnotifyUserProperties userProps) {
        super(userProps);
    }

    @Override
    protected SmimeEncryptionKey loadInternalKey(IUser<?> user) throws Exception {
        ISnotifyUserProperties userProps = this.getUserProperties();
        byte[] cert = userProps.getBytes(EProperty.EMAIL_SMIME_CERT, user);
        if (cert != null) {
            log.debug("Loading cached certificate of user {} from user properties.", user);
            try {
                X509Certificate certificate = SmimeUtil.createCertificate(cert);
                SmimeEncryptionKey key = new SmimeEncryptionKey(certificate, user.getEmail());
                key.setKeySource(this.getUserKeySource(user));
                return key;
            }
            catch (CertificateException e) {
                log.error("Could not parse certificate stored for user " + String.valueOf(user) + ". Error message: " + e.getMessage(), (Throwable)e);
                return this.getValidityKey(EKeyValidity.ERROR);
            }
        }
        log.debug("User {} has no cached certificate stored.", user);
        return this.getValidityKey(EKeyValidity.NOT_FOUND);
    }

    private EKeySource getUserKeySource(IUser<?> user) {
        EKeySource keySource = this.getUserProperties().getEnum(EProperty.EMAIL_SMIME_KEY_SOURCE, EKeySource.class, user);
        if (keySource != null) {
            return keySource;
        }
        return this.getKeySource();
    }

    @Override
    public ECryptographyType getCryptography() {
        return ECryptographyType.SMIME;
    }

    @Override
    protected SmimeEncryptionKey getValidityKey(EKeyValidity validity) {
        return new SmimeEncryptionKey(validity, this.getKeySource());
    }
}

