/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.atlassian.mailer.keysource;

import java.io.IOException;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.DestroyFailedException;
import net.savignano.cryptography.enums.EKeySource;
import net.savignano.cryptography.enums.EKeyValidity;
import net.savignano.cryptography.key.ISecretCryptographyKey;
import net.savignano.snotify.atlassian.common.EProperty;
import net.savignano.snotify.atlassian.common.properties.ISnotifyAppProperties;
import net.savignano.snotify.atlassian.mailer.keysource.AKeyManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class APrivateKeyManager<T extends ISecretCryptographyKey<?>, U>
extends AKeyManager<T, U> {
    private static final Logger log = LoggerFactory.getLogger(APrivateKeyManager.class);
    private static final Map<Class<?>, Map<?, ? extends ISecretCryptographyKey<?>>> cachedKeys = new HashMap();
    private static final Map<Class<?>, Map<?, Calendar>> cachedTimeStamps = new HashMap();

    public APrivateKeyManager(ISnotifyAppProperties appProps) {
        super(appProps);
        this.initValues();
    }

    private void initValues() {
        Map<?, ? extends ISecretCryptographyKey<?>> keyMap;
        Map<?, Calendar> timeStampMap = cachedTimeStamps.get(this.getCacheClass());
        if (timeStampMap == null) {
            timeStampMap = new HashMap();
            cachedTimeStamps.put(this.getCacheClass(), timeStampMap);
        }
        if ((keyMap = cachedKeys.get(this.getCacheClass())) == null) {
            keyMap = new HashMap();
            cachedKeys.put(this.getCacheClass(), keyMap);
        }
    }

    protected void clearCache() {
        cachedKeys.get(this.getCacheClass()).clear();
        cachedTimeStamps.get(this.getCacheClass()).clear();
    }

    @Override
    protected T getCachedKey(U forId) {
        Map<?, ISecretCryptographyKey<?>> keyMap = cachedKeys.get(this.getCacheClass());
        ISecretCryptographyKey<?> cachedKey = keyMap.get(forId);
        if (cachedKey != null) {
            return (T)cachedKey;
        }
        return (T)((ISecretCryptographyKey)this.getValidityKey(EKeyValidity.NOT_FOUND, EKeySource.UNKNOWN));
    }

    @Override
    protected void setCachedKey(U forId, T key) throws IOException {
        ISecretCryptographyKey<?> oldKey;
        Map<?, ISecretCryptographyKey<?>> map = cachedKeys.get(this.getCacheClass());
        if (key == null) {
            log.debug("Clearing key from cache.");
            oldKey = map.remove(forId);
        } else {
            log.debug("Storing new key in cache: {}", key);
            oldKey = map.put(forId, (ISecretCryptographyKey<?>)key);
        }
        if (oldKey != null && oldKey != key) {
            try {
                log.debug("Destroying old key: {}", oldKey);
                oldKey.destroy();
            }
            catch (DestroyFailedException e) {
                log.error("Could not destroy old key. Error message: " + e.getMessage(), (Throwable)e);
            }
        }
        this.setCachedTimeStamp(forId, Calendar.getInstance());
    }

    @Override
    protected boolean isCachedKeyUsable(T key, U forId) {
        if (!super.isCachedKeyUsable(key, forId)) {
            return false;
        }
        if (key.isDestroyed()) {
            log.debug("Cached key unusable: Key already destroyed.");
            return false;
        }
        return true;
    }

    @Override
    protected boolean isCacheAutomaticallyExpired(U forId) {
        if (super.isCacheAutomaticallyExpired(forId)) {
            return true;
        }
        Calendar cachedTimeStamp = this.getCachedTimeStamp(forId);
        if (cachedTimeStamp == null) {
            log.debug("Cache automatically expired: No cache timestamp.");
            return true;
        }
        if (Calendar.getInstance().get(5) != cachedTimeStamp.get(5)) {
            log.debug("Cache automatically expired: New day.");
            return true;
        }
        return false;
    }

    @Override
    protected boolean isCacheManuallyExpired(U forId) {
        Long expireTimeStamp;
        if (super.isCacheManuallyExpired(forId)) {
            return true;
        }
        Calendar cachedTimeStamp = this.getCachedTimeStamp(forId);
        if (cachedTimeStamp != null && (expireTimeStamp = this.getAppProps().getLong(EProperty.EXPIRE_KEYS_PRIVATE_TIMESTAMP)) != null && expireTimeStamp > cachedTimeStamp.getTimeInMillis()) {
            log.debug("Cache manually expired: Timestamp expired.");
            return true;
        }
        return false;
    }

    protected Calendar getCachedTimeStamp(U forId) {
        Map<?, Calendar> timeStampMap = cachedTimeStamps.get(this.getCacheClass());
        Calendar cachedTimeStamp = timeStampMap.get(forId);
        return cachedTimeStamp;
    }

    protected void setCachedTimeStamp(U forId, Calendar cachedTimeStamp) {
        Map<?, Calendar> map = cachedTimeStamps.get(this.getCacheClass());
        map.put(forId, cachedTimeStamp);
    }

    protected abstract Class<?> getCacheClass();
}

