/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.atlassian.mailer.keysource.smime;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import net.savignano.cryptography.connector.LdapConnector;
import net.savignano.cryptography.enums.EKeySource;
import net.savignano.cryptography.enums.EKeyValidity;
import net.savignano.cryptography.key.loader.IKeyLoader;
import net.savignano.cryptography.key.loader.KeyLoaderTransformer;
import net.savignano.cryptography.key.loader.smime.SmimeCertificateKeyStoreLoader;
import net.savignano.cryptography.key.loader.smime.SmimeCertificateP7bLoader;
import net.savignano.cryptography.key.loader.smime.SmimeLdapLoader;
import net.savignano.cryptography.key.smime.SmimeEncryptionKey;
import net.savignano.cryptography.util.SecurityUtil;
import net.savignano.snotify.atlassian.common.EProperty;
import net.savignano.snotify.atlassian.common.properties.ISnotifyAppProperties;
import net.savignano.snotify.atlassian.common.properties.ISnotifyUserProperties;
import net.savignano.snotify.atlassian.common.security.access.smime.SmimeUserKeyLoader;
import net.savignano.snotify.atlassian.common.user.IUser;
import net.savignano.snotify.atlassian.mailer.keysource.APublicKeyManager;
import net.savignano.thirdparty.org.bouncycastle.cms.CMSSignedData;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmimePublicKeyManager
extends APublicKeyManager<SmimeEncryptionKey, IUser<?>> {
    private static final Logger log = LoggerFactory.getLogger(SmimePublicKeyManager.class);

    public SmimePublicKeyManager(ISnotifyAppProperties appProps, ISnotifyUserProperties userProps) {
        super(EProperty.EMAIL_SMIME_TIME_STAMP, appProps, userProps);
    }

    @Override
    protected List<Map.Entry<EKeySource, Supplier<Optional<IKeyLoader<SmimeEncryptionKey, IUser<?>>>>>> getKeyLoaders() {
        ArrayList loaders = new ArrayList();
        loaders.add(new AbstractMap.SimpleEntry<EKeySource, Supplier<Optional>>(EKeySource.KEYSTORE, this::createKeyStoreLoader));
        loaders.add(new AbstractMap.SimpleEntry<EKeySource, Supplier<Optional>>(EKeySource.STANDARD_LDAP, this::createExternalLdapLoader));
        return loaders;
    }

    private Optional<IKeyLoader<SmimeEncryptionKey, IUser<?>>> createExternalLdapLoader() {
        String location = this.getAppProps().getString(EProperty.PUBLIC_LDAP_HOST_SMIME);
        if (location == null) {
            log.debug("No external LDAP for S/MIME specified. Can't get certificate from LDAP.");
            return Optional.empty();
        }
        LdapConnector connector = new LdapConnector();
        connector.setHost(location);
        connector.setPort(this.getAppProps().getLong(EProperty.PUBLIC_LDAP_PORT_SMIME).intValue());
        connector.setSsl(this.getAppProps().getBoolean(EProperty.PUBLIC_LDAP_SSL_SMIME));
        connector.setDn(this.getAppProps().getString(EProperty.PUBLIC_LDAP_DN_SMIME));
        connector.setFilter(this.getAppProps().getString(EProperty.PUBLIC_LDAP_FILTER_SMIME));
        connector.setLoginUser(this.getAppProps().getString(EProperty.PUBLIC_LDAP_LOGIN_USER_SMIME));
        connector.setLoginPassword(this.getAppProps().getPassword(EProperty.PUBLIC_LDAP_LOGIN_PASSWORD_SMIME));
        connector.setReferral(this.getAppProps().getString(EProperty.PUBLIC_LDAP_REFERRAL_SMIME));
        connector.setDisableTrustCheck(this.getAppProps().getBoolean(EProperty.TWEAK_EXTERNAL_LDAP_INSECURE));
        SmimeLdapLoader loader = new SmimeLdapLoader(connector);
        loader.setIgnoreCriticalExtension(!this.getAppProps().getBoolean(EProperty.TWEAK_SMIME_STRICT_CERTIFICATE_CHECKING));
        if (this.getAppProps().hasKey(EProperty.TWEAK_LDAP_CONTEXT_REFERRAL)) {
            loader.setEnvironment(Collections.singletonMap("java.naming.referral", this.getAppProps().getString(EProperty.TWEAK_LDAP_CONTEXT_REFERRAL)));
        }
        return Optional.of(KeyLoaderTransformer.create(loader, this::createExternalLdalFunction));
    }

    private Pair<String, String> createExternalLdalFunction(IUser<?> user) {
        String address = user.getEmail();
        String mailAttr = this.getAppProps().getString(EProperty.PUBLIC_LDAP_MAILATTR_SMIME);
        String userFilter = "(" + mailAttr + "=" + address + ")";
        return Pair.of((Object)userFilter, (Object)address);
    }

    private Optional<IKeyLoader<SmimeEncryptionKey, IUser<?>>> createKeyStoreLoader() {
        String location = this.getAppProps().getString(EProperty.PUBLIC_KEYSTORE_SMIME_LOCATION);
        if (location == null) {
            log.debug("No key store specified. Can't get certificate from key store.");
            return Optional.empty();
        }
        String type = this.getAppProps().getString(EProperty.PUBLIC_KEYSTORE_SMIME_TYPE);
        if (type == null) {
            log.debug("No key store type specified. Can't get certificate from key store.");
            return Optional.empty();
        }
        log.debug("Key store type: {}", (Object)type);
        switch (type) {
            case "BKS": {
                return this.createKeyStoreLoader(location, type);
            }
            case "PKCS7": {
                return this.createP7bStoreLoader(location);
            }
        }
        log.error("Could not load key store from location \"{}\". Unknown key store type encountered: {}", (Object)type);
        return Optional.empty();
    }

    private Optional<IKeyLoader<SmimeEncryptionKey, IUser<?>>> createKeyStoreLoader(String location, String type) {
        try {
            KeyStore ks = KeyStore.getInstance(type, SecurityUtil.getProvider());
            log.debug("Loading key store from location: {}", (Object)location);
            try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(location));){
                ks.load(in, null);
            }
            log.debug("Loaded key store from location \"{}\" successfully.", (Object)location);
            SmimeCertificateKeyStoreLoader loader = new SmimeCertificateKeyStoreLoader(ks);
            loader.setIgnoreCriticalExtension(!this.getAppProps().getBoolean(EProperty.TWEAK_SMIME_STRICT_CERTIFICATE_CHECKING));
            return Optional.of(KeyLoaderTransformer.create(loader, u -> u.getEmail()));
        }
        catch (Exception e) {
            log.error("Could not load key store from location \"" + location + "\". Error message: " + e.getMessage(), (Throwable)e);
            return Optional.empty();
        }
    }

    private Optional<IKeyLoader<SmimeEncryptionKey, IUser<?>>> createP7bStoreLoader(String location) {
        CMSSignedData signature;
        log.debug("Loading P7B store from location: {}", (Object)location);
        try (BufferedInputStream is = new BufferedInputStream(new FileInputStream(location));){
            log.debug("Loaded P7B store from location \"{}\" successfully.", (Object)location);
            signature = new CMSSignedData(is);
        }
        catch (Exception e) {
            log.error("Could not load P7B store from location \"" + location + "\". Error message: " + e.getMessage(), (Throwable)e);
            return Optional.empty();
        }
        SmimeCertificateP7bLoader loader = new SmimeCertificateP7bLoader(signature.getCertificates());
        loader.setIgnoreCriticalExtension(!this.getAppProps().getBoolean(EProperty.TWEAK_SMIME_STRICT_CERTIFICATE_CHECKING));
        return Optional.of(KeyLoaderTransformer.create(loader, u -> u.getEmail()));
    }

    @Override
    protected boolean isCachedKeyUsable(SmimeEncryptionKey key, IUser<?> user) {
        if (!super.isCachedKeyUsable(key, user)) {
            return false;
        }
        if (key.getKeySource() == EKeySource.USER && !this.getAppProps().getBoolean(EProperty.ALLOW_SMIME_CERTIFICATE_OVERWRITE)) {
            log.debug("Cached key unusable: User key, but admin does not allow such keys.");
            return false;
        }
        return true;
    }

    @Override
    protected SmimeEncryptionKey getCachedKey(IUser<?> user) {
        if (!user.isActualUser()) {
            log.debug("No user given to retrieve S/MIME public keys from.");
            return this.getValidityKey(EKeyValidity.NOT_FOUND, EKeySource.UNKNOWN);
        }
        SmimeUserKeyLoader loader = new SmimeUserKeyLoader(this.getUserProps());
        return (SmimeEncryptionKey)loader.loadKey(user);
    }

    @Override
    protected void setCachedKey(IUser<?> user, SmimeEncryptionKey key) throws IOException {
        ISnotifyUserProperties userProps = this.getUserProps();
        if (key == null) {
            log.debug("Clearing S/MIME certificate from user properties.");
            userProps.setBytes(EProperty.EMAIL_SMIME_CERT, null, user);
            userProps.setEnum(EProperty.EMAIL_SMIME_KEY_SOURCE, null, user);
        } else {
            log.debug("Storing new S/MIME certificate to user properties: {}", (Object)key.getKey());
            userProps.setBytes(EProperty.EMAIL_SMIME_CERT, key.getEncoded(), user);
            userProps.setEnum(EProperty.EMAIL_SMIME_KEY_SOURCE, key.getKeySource(), user);
        }
        userProps.setLong(EProperty.EMAIL_SMIME_TIME_STAMP, System.currentTimeMillis(), user);
    }

    @Override
    protected SmimeEncryptionKey getValidityKey(EKeyValidity validity, EKeySource keySource) {
        return new SmimeEncryptionKey(validity, keySource);
    }
}

