/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.confluence.common;

import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.component.ComponentLocator;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import net.savignano.snotify.atlassian.common.properties.ASnotifyProjectProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SnotifySpaceProperties
extends ASnotifyProjectProperties {
    private static final Logger log = LoggerFactory.getLogger(SnotifySpaceProperties.class);
    @Autowired
    @ComponentImport
    private PluginSettingsFactory factory;

    @Override
    protected String get(String key, String projectKey) throws Exception {
        return (String)this.getSettings(projectKey).get(key);
    }

    @Override
    protected void set(String key, String value, String projectKey) throws Exception {
        this.getSettings(projectKey).put(key, (Object)value);
    }

    @Override
    protected void remove(String key, String projectKey) throws Exception {
        this.getSettings(projectKey).remove(key);
    }

    private PluginSettings getSettings(String projectKey) {
        return this.getFactory().createSettingsForKey(projectKey);
    }

    private PluginSettingsFactory getFactory() {
        if (this.factory == null) {
            log.trace("Injection of BandanaManager failed. Loading manually.");
            this.factory = (PluginSettingsFactory)ComponentLocator.getComponent(PluginSettingsFactory.class);
        }
        return this.factory;
    }
}

