/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.confluence.mailer.service.permission;

import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PermissionAwareService {
    private ConfluenceUser user;

    public PermissionAwareService() {
        this(null);
    }

    public PermissionAwareService(ConfluenceUser user) {
        this.setUser(user);
    }

    public ConfluenceUser getUser() {
        return this.user;
    }

    public void setUser(ConfluenceUser user) {
        this.user = user;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T> T runPermissionAware(Supplier<T> supplier) {
        Logger log = LoggerFactory.getLogger(PermissionAwareService.class);
        if (this.getUser() == null) {
            log.trace("No user given. Executing without permission awareness.");
            return supplier.get();
        }
        log.trace("Executing with permission awareness of user: {}", (Object)this.getUser());
        ConfluenceUser oldUser = AuthenticatedUserThreadLocal.get();
        try {
            AuthenticatedUserThreadLocal.set((ConfluenceUser)this.getUser());
            T t = supplier.get();
            return t;
        }
        finally {
            AuthenticatedUserThreadLocal.set((ConfluenceUser)oldUser);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runPermissionAware(Runnable runnable) {
        Logger log = LoggerFactory.getLogger(PermissionAwareService.class);
        if (this.getUser() == null) {
            log.trace("No user given. Executing without permission awareness.");
            runnable.run();
            return;
        }
        log.trace("Executing with permission awareness of user: {}", (Object)this.getUser());
        ConfluenceUser oldUser = AuthenticatedUserThreadLocal.get();
        try {
            AuthenticatedUserThreadLocal.set((ConfluenceUser)this.getUser());
            runnable.run();
        }
        finally {
            AuthenticatedUserThreadLocal.set((ConfluenceUser)oldUser);
        }
    }
}

