/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.asn1.eac;

import java.io.IOException;
import java.util.Enumeration;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1EncodableVector;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Object;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1OctetString;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1ParsingException;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Primitive;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Sequence;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1TaggedObject;
import net.savignano.thirdparty.org.bouncycastle.asn1.DERSequence;
import net.savignano.thirdparty.org.bouncycastle.asn1.eac.CertificateBody;
import net.savignano.thirdparty.org.bouncycastle.asn1.eac.EACTagged;
import net.savignano.thirdparty.org.bouncycastle.asn1.eac.PublicKeyDataObject;
import net.savignano.thirdparty.org.bouncycastle.util.Arrays;

public class CVCertificateRequest
extends ASN1Object {
    private final ASN1TaggedObject original;
    private CertificateBody certificateBody;
    private byte[] innerSignature = null;
    private byte[] outerSignature = null;
    private static final int bodyValid = 1;
    private static final int signValid = 2;

    private CVCertificateRequest(ASN1TaggedObject request) throws IOException {
        this.original = request;
        if (request.hasTag(64, 7)) {
            ASN1Sequence seq = ASN1Sequence.getInstance(request.getBaseUniversal(false, 16));
            this.initCertBody(ASN1TaggedObject.getInstance(seq.getObjectAt(0), 64));
            this.outerSignature = ASN1OctetString.getInstance(ASN1TaggedObject.getInstance(seq.getObjectAt(seq.size() - 1)).getBaseUniversal(false, 4)).getOctets();
        } else {
            this.initCertBody(request);
        }
    }

    private void initCertBody(ASN1TaggedObject request) throws IOException {
        if (request.hasTag(64, 33)) {
            int valid = 0;
            ASN1Sequence seq = ASN1Sequence.getInstance(request.getBaseUniversal(false, 16));
            Enumeration en = seq.getObjects();
            block4: while (en.hasMoreElements()) {
                ASN1TaggedObject tObj = ASN1TaggedObject.getInstance(en.nextElement(), 64);
                switch (tObj.getTagNo()) {
                    case 78: {
                        this.certificateBody = CertificateBody.getInstance(tObj);
                        valid |= 1;
                        continue block4;
                    }
                    case 55: {
                        this.innerSignature = ASN1OctetString.getInstance(tObj.getBaseUniversal(false, 4)).getOctets();
                        valid |= 2;
                        continue block4;
                    }
                }
                throw new IOException("Invalid tag, not an CV Certificate Request element:" + tObj.getTagNo());
            }
            if ((valid & 3) == 0) {
                throw new IOException("Invalid CARDHOLDER_CERTIFICATE in request:" + request.getTagNo());
            }
        } else {
            throw new IOException("not a CARDHOLDER_CERTIFICATE in request:" + request.getTagNo());
        }
    }

    public static CVCertificateRequest getInstance(Object obj) {
        if (obj instanceof CVCertificateRequest) {
            return (CVCertificateRequest)obj;
        }
        if (obj != null) {
            try {
                return new CVCertificateRequest(ASN1TaggedObject.getInstance(obj, 64));
            }
            catch (IOException e) {
                throw new ASN1ParsingException("unable to parse data: " + e.getMessage(), e);
            }
        }
        return null;
    }

    public CertificateBody getCertificateBody() {
        return this.certificateBody;
    }

    public PublicKeyDataObject getPublicKey() {
        return this.certificateBody.getPublicKey();
    }

    public byte[] getInnerSignature() {
        return Arrays.clone(this.innerSignature);
    }

    public byte[] getOuterSignature() {
        return Arrays.clone(this.outerSignature);
    }

    public boolean hasOuterSignature() {
        return this.outerSignature != null;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        if (this.original != null) {
            return this.original;
        }
        ASN1EncodableVector v = new ASN1EncodableVector(2);
        v.add(this.certificateBody);
        v.add(EACTagged.create(55, this.innerSignature));
        return EACTagged.create(33, new DERSequence(v));
    }
}

