/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.cert.crmf;

import java.io.IOException;
import net.savignano.thirdparty.org.bouncycastle.asn1.cms.EnvelopedData;
import net.savignano.thirdparty.org.bouncycastle.asn1.crmf.CRMFObjectIdentifiers;
import net.savignano.thirdparty.org.bouncycastle.asn1.crmf.EncKeyWithID;
import net.savignano.thirdparty.org.bouncycastle.asn1.crmf.EncryptedKey;
import net.savignano.thirdparty.org.bouncycastle.asn1.crmf.PKIArchiveOptions;
import net.savignano.thirdparty.org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import net.savignano.thirdparty.org.bouncycastle.asn1.x509.GeneralName;
import net.savignano.thirdparty.org.bouncycastle.cert.crmf.PKIArchiveControl;
import net.savignano.thirdparty.org.bouncycastle.cms.CMSEnvelopedData;
import net.savignano.thirdparty.org.bouncycastle.cms.CMSEnvelopedDataGenerator;
import net.savignano.thirdparty.org.bouncycastle.cms.CMSException;
import net.savignano.thirdparty.org.bouncycastle.cms.CMSProcessableByteArray;
import net.savignano.thirdparty.org.bouncycastle.cms.RecipientInfoGenerator;
import net.savignano.thirdparty.org.bouncycastle.operator.OutputEncryptor;

public class PKIArchiveControlBuilder {
    private CMSEnvelopedDataGenerator envGen;
    private CMSProcessableByteArray keyContent;

    public PKIArchiveControlBuilder(PrivateKeyInfo privateKeyInfo, GeneralName generalName) {
        EncKeyWithID encKeyWithID = new EncKeyWithID(privateKeyInfo, generalName);
        try {
            this.keyContent = new CMSProcessableByteArray(CRMFObjectIdentifiers.id_ct_encKeyWithID, encKeyWithID.getEncoded());
        }
        catch (IOException e) {
            throw new IllegalStateException("unable to encode key and general name info");
        }
        this.envGen = new CMSEnvelopedDataGenerator();
    }

    public PKIArchiveControlBuilder addRecipientGenerator(RecipientInfoGenerator recipientGen) {
        this.envGen.addRecipientInfoGenerator(recipientGen);
        return this;
    }

    public PKIArchiveControl build(OutputEncryptor contentEncryptor) throws CMSException {
        CMSEnvelopedData envContent = this.envGen.generate(this.keyContent, contentEncryptor);
        EnvelopedData envD = EnvelopedData.getInstance(envContent.toASN1Structure().getContent());
        return new PKIArchiveControl(new PKIArchiveOptions(new EncryptedKey(envD)));
    }
}

