/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.crypto.digests;

import net.savignano.thirdparty.org.bouncycastle.crypto.Digest;
import net.savignano.thirdparty.org.bouncycastle.util.io.LimitedBuffer;

public class Prehash
implements Digest {
    private final String algorithmName;
    private final LimitedBuffer buf;

    public static Prehash forDigest(Digest digest) {
        return new Prehash(digest);
    }

    private Prehash(Digest digest) {
        this.algorithmName = digest.getAlgorithmName();
        this.buf = new LimitedBuffer(digest.getDigestSize());
    }

    @Override
    public String getAlgorithmName() {
        return this.algorithmName;
    }

    @Override
    public int getDigestSize() {
        return this.buf.limit();
    }

    @Override
    public void update(byte in) {
        this.buf.write(in);
    }

    @Override
    public void update(byte[] in, int inOff, int len) {
        this.buf.write(in, inOff, len);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int doFinal(byte[] out, int outOff) {
        try {
            if (this.getDigestSize() != this.buf.size()) {
                throw new IllegalStateException("Incorrect prehash size");
            }
            int n = this.buf.copyTo(out, outOff);
            return n;
        }
        finally {
            this.reset();
        }
    }

    @Override
    public void reset() {
        this.buf.reset();
    }
}

