/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.math.ec;

import java.math.BigInteger;
import net.savignano.thirdparty.org.bouncycastle.math.ec.ECAlgorithms;
import net.savignano.thirdparty.org.bouncycastle.math.ec.ECMultiplier;
import net.savignano.thirdparty.org.bouncycastle.math.ec.ECPoint;

public abstract class AbstractECMultiplier
implements ECMultiplier {
    @Override
    public ECPoint multiply(ECPoint p, BigInteger k) {
        int sign = k.signum();
        if (sign == 0 || p.isInfinity()) {
            return p.getCurve().getInfinity();
        }
        ECPoint positive = this.multiplyPositive(p, k.abs());
        ECPoint result = sign > 0 ? positive : positive.negate();
        return this.checkResult(result);
    }

    protected abstract ECPoint multiplyPositive(ECPoint var1, BigInteger var2);

    protected ECPoint checkResult(ECPoint p) {
        return ECAlgorithms.implCheckResult(p);
    }
}

