/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.openpgp;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.NoSuchElementException;
import net.savignano.thirdparty.org.bouncycastle.bcpg.BCPGInputStream;
import net.savignano.thirdparty.org.bouncycastle.bcpg.UnknownPacket;
import net.savignano.thirdparty.org.bouncycastle.bcpg.UnsupportedPacketVersionException;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPCompressedData;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPEncryptedDataList;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPException;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPLiteralData;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPMarker;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPOnePassSignature;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPOnePassSignatureList;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPPadding;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPPublicKeyRing;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPRuntimeOperationException;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPSecretKeyRing;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPSignature;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPSignatureList;
import net.savignano.thirdparty.org.bouncycastle.openpgp.operator.KeyFingerPrintCalculator;
import net.savignano.thirdparty.org.bouncycastle.util.Iterable;

public class PGPObjectFactory
implements Iterable {
    private BCPGInputStream in;
    private KeyFingerPrintCalculator fingerPrintCalculator;
    private boolean throwForUnknownCriticalPackets = false;

    public PGPObjectFactory(InputStream in, KeyFingerPrintCalculator fingerPrintCalculator) {
        this.in = BCPGInputStream.wrap(in);
        this.fingerPrintCalculator = fingerPrintCalculator;
    }

    public PGPObjectFactory(byte[] bytes, KeyFingerPrintCalculator fingerPrintCalculator) {
        this(new ByteArrayInputStream(bytes), fingerPrintCalculator);
    }

    public Object nextObject() throws IOException {
        switch (this.in.nextPacketTag()) {
            case -1: {
                return null;
            }
            case 0: 
            case 60: 
            case 61: 
            case 62: 
            case 63: {
                return this.in.readPacket();
            }
            case 2: {
                ArrayList<PGPSignature> l = new ArrayList<PGPSignature>();
                while (this.in.nextPacketTag() == 2) {
                    try {
                        l.add(new PGPSignature(this.in));
                    }
                    catch (UnsupportedPacketVersionException e) {
                    }
                    catch (PGPException e) {
                        throw new IOException("can't create signature object: " + e);
                    }
                }
                return new PGPSignatureList(l.toArray(new PGPSignature[l.size()]));
            }
            case 5: {
                try {
                    return new PGPSecretKeyRing(this.in, this.fingerPrintCalculator);
                }
                catch (PGPException e) {
                    throw new IOException("can't create secret key object: " + e);
                }
            }
            case 6: {
                return new PGPPublicKeyRing(this.in, this.fingerPrintCalculator);
            }
            case 14: {
                try {
                    return PGPPublicKeyRing.readSubkey(this.in, this.fingerPrintCalculator);
                }
                catch (PGPException e) {
                    throw new IOException("processing error: " + e.getMessage());
                }
            }
            case 8: {
                return new PGPCompressedData(this.in);
            }
            case 11: {
                return new PGPLiteralData(this.in);
            }
            case 1: 
            case 3: 
            case 9: 
            case 18: 
            case 20: {
                return new PGPEncryptedDataList(this.in);
            }
            case 4: {
                ArrayList<PGPOnePassSignature> l = new ArrayList<PGPOnePassSignature>();
                while (this.in.nextPacketTag() == 4) {
                    try {
                        l.add(new PGPOnePassSignature(this.in));
                    }
                    catch (PGPException e) {
                        throw new IOException("can't create one pass signature object: " + e);
                    }
                }
                return new PGPOnePassSignatureList(l.toArray(new PGPOnePassSignature[l.size()]));
            }
            case 10: {
                return new PGPMarker(this.in);
            }
            case 21: {
                return new PGPPadding(this.in);
            }
        }
        int tag = this.in.nextPacketTag();
        UnknownPacket unknownPacket = (UnknownPacket)this.in.readPacket();
        if (this.throwForUnknownCriticalPackets && unknownPacket.isCritical()) {
            throw new IOException("unknown object in stream: " + tag);
        }
        return unknownPacket;
    }

    @Override
    public Iterator iterator() {
        return new Iterator(){
            private boolean triedNext = false;
            private Object obj = null;

            @Override
            public boolean hasNext() {
                if (!this.triedNext) {
                    this.triedNext = true;
                    this.obj = this.getObject();
                }
                return this.obj != null;
            }

            public Object next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.triedNext = false;
                return this.obj;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Cannot remove element from factory.");
            }

            private Object getObject() {
                try {
                    return PGPObjectFactory.this.nextObject();
                }
                catch (IOException e) {
                    throw new PGPRuntimeOperationException("Iterator failed to get next object: " + e.getMessage(), e);
                }
            }
        };
    }

    public PGPObjectFactory setThrowForUnknownCriticalPackets(boolean throwException) {
        this.throwForUnknownCriticalPackets = throwException;
        return this;
    }
}

