/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.openpgp.operator.bc;

import java.io.IOException;
import java.math.BigInteger;
import java.util.Date;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import net.savignano.thirdparty.org.bouncycastle.asn1.cryptlib.CryptlibObjectIdentifiers;
import net.savignano.thirdparty.org.bouncycastle.asn1.edec.EdECObjectIdentifiers;
import net.savignano.thirdparty.org.bouncycastle.asn1.gnu.GNUObjectIdentifiers;
import net.savignano.thirdparty.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import net.savignano.thirdparty.org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import net.savignano.thirdparty.org.bouncycastle.asn1.x9.X9ECParameters;
import net.savignano.thirdparty.org.bouncycastle.bcpg.BCPGKey;
import net.savignano.thirdparty.org.bouncycastle.bcpg.DSAPublicBCPGKey;
import net.savignano.thirdparty.org.bouncycastle.bcpg.DSASecretBCPGKey;
import net.savignano.thirdparty.org.bouncycastle.bcpg.ECDHPublicBCPGKey;
import net.savignano.thirdparty.org.bouncycastle.bcpg.ECDSAPublicBCPGKey;
import net.savignano.thirdparty.org.bouncycastle.bcpg.ECPublicBCPGKey;
import net.savignano.thirdparty.org.bouncycastle.bcpg.ECSecretBCPGKey;
import net.savignano.thirdparty.org.bouncycastle.bcpg.Ed25519PublicBCPGKey;
import net.savignano.thirdparty.org.bouncycastle.bcpg.Ed25519SecretBCPGKey;
import net.savignano.thirdparty.org.bouncycastle.bcpg.Ed448PublicBCPGKey;
import net.savignano.thirdparty.org.bouncycastle.bcpg.Ed448SecretBCPGKey;
import net.savignano.thirdparty.org.bouncycastle.bcpg.EdDSAPublicBCPGKey;
import net.savignano.thirdparty.org.bouncycastle.bcpg.EdSecretBCPGKey;
import net.savignano.thirdparty.org.bouncycastle.bcpg.ElGamalPublicBCPGKey;
import net.savignano.thirdparty.org.bouncycastle.bcpg.ElGamalSecretBCPGKey;
import net.savignano.thirdparty.org.bouncycastle.bcpg.OctetArrayBCPGKey;
import net.savignano.thirdparty.org.bouncycastle.bcpg.PublicKeyPacket;
import net.savignano.thirdparty.org.bouncycastle.bcpg.RSAPublicBCPGKey;
import net.savignano.thirdparty.org.bouncycastle.bcpg.RSASecretBCPGKey;
import net.savignano.thirdparty.org.bouncycastle.bcpg.X25519PublicBCPGKey;
import net.savignano.thirdparty.org.bouncycastle.bcpg.X25519SecretBCPGKey;
import net.savignano.thirdparty.org.bouncycastle.bcpg.X448PublicBCPGKey;
import net.savignano.thirdparty.org.bouncycastle.bcpg.X448SecretBCPGKey;
import net.savignano.thirdparty.org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import net.savignano.thirdparty.org.bouncycastle.crypto.params.DSAParameters;
import net.savignano.thirdparty.org.bouncycastle.crypto.params.DSAPrivateKeyParameters;
import net.savignano.thirdparty.org.bouncycastle.crypto.params.DSAPublicKeyParameters;
import net.savignano.thirdparty.org.bouncycastle.crypto.params.ECDomainParameters;
import net.savignano.thirdparty.org.bouncycastle.crypto.params.ECNamedDomainParameters;
import net.savignano.thirdparty.org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import net.savignano.thirdparty.org.bouncycastle.crypto.params.ECPublicKeyParameters;
import net.savignano.thirdparty.org.bouncycastle.crypto.params.Ed25519PrivateKeyParameters;
import net.savignano.thirdparty.org.bouncycastle.crypto.params.Ed25519PublicKeyParameters;
import net.savignano.thirdparty.org.bouncycastle.crypto.params.Ed448PrivateKeyParameters;
import net.savignano.thirdparty.org.bouncycastle.crypto.params.Ed448PublicKeyParameters;
import net.savignano.thirdparty.org.bouncycastle.crypto.params.ElGamalParameters;
import net.savignano.thirdparty.org.bouncycastle.crypto.params.ElGamalPrivateKeyParameters;
import net.savignano.thirdparty.org.bouncycastle.crypto.params.ElGamalPublicKeyParameters;
import net.savignano.thirdparty.org.bouncycastle.crypto.params.RSAKeyParameters;
import net.savignano.thirdparty.org.bouncycastle.crypto.params.RSAPrivateCrtKeyParameters;
import net.savignano.thirdparty.org.bouncycastle.crypto.params.X25519PrivateKeyParameters;
import net.savignano.thirdparty.org.bouncycastle.crypto.params.X25519PublicKeyParameters;
import net.savignano.thirdparty.org.bouncycastle.crypto.params.X448PrivateKeyParameters;
import net.savignano.thirdparty.org.bouncycastle.crypto.params.X448PublicKeyParameters;
import net.savignano.thirdparty.org.bouncycastle.crypto.util.PrivateKeyFactory;
import net.savignano.thirdparty.org.bouncycastle.crypto.util.PublicKeyFactory;
import net.savignano.thirdparty.org.bouncycastle.math.ec.ECPoint;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPAlgorithmParameters;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPException;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPKdfParameters;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPPrivateKey;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPPublicKey;
import net.savignano.thirdparty.org.bouncycastle.openpgp.operator.PGPKeyConverter;
import net.savignano.thirdparty.org.bouncycastle.openpgp.operator.bc.BcKeyFingerprintCalculator;
import net.savignano.thirdparty.org.bouncycastle.openpgp.operator.bc.BcUtil;
import net.savignano.thirdparty.org.bouncycastle.util.Arrays;
import net.savignano.thirdparty.org.bouncycastle.util.BigIntegers;

public class BcPGPKeyConverter
extends PGPKeyConverter {
    public PGPPrivateKey getPGPPrivateKey(PGPPublicKey pubKey, AsymmetricKeyParameter privKey) throws PGPException {
        BCPGKey privPk = this.getPrivateBCPGKey(pubKey, privKey);
        return new PGPPrivateKey(pubKey.getKeyID(), pubKey.getPublicKeyPacket(), privPk);
    }

    public PGPPublicKey getPGPPublicKey(int algorithm, PGPAlgorithmParameters algorithmParameters, AsymmetricKeyParameter pubKey, Date time) throws PGPException {
        BCPGKey bcpgKey = this.getPublicBCPGKey(algorithm, algorithmParameters, pubKey);
        return new PGPPublicKey(new PublicKeyPacket(algorithm, time, bcpgKey), new BcKeyFingerprintCalculator());
    }

    public AsymmetricKeyParameter getPrivateKey(PGPPrivateKey privKey) throws PGPException {
        PublicKeyPacket pubPk = privKey.getPublicKeyPacket();
        BCPGKey privPk = privKey.getPrivateKeyDataPacket();
        try {
            switch (pubPk.getAlgorithm()) {
                case 17: {
                    DSAPublicBCPGKey dsaPub = (DSAPublicBCPGKey)pubPk.getKey();
                    DSASecretBCPGKey dsaPriv = (DSASecretBCPGKey)privPk;
                    return new DSAPrivateKeyParameters(dsaPriv.getX(), new DSAParameters(dsaPub.getP(), dsaPub.getQ(), dsaPub.getG()));
                }
                case 18: {
                    ECDHPublicBCPGKey ecdhPub = (ECDHPublicBCPGKey)pubPk.getKey();
                    if (CryptlibObjectIdentifiers.curvey25519.equals(ecdhPub.getCurveOID())) {
                        return PrivateKeyFactory.createKey(this.getPrivateKeyInfo(EdECObjectIdentifiers.id_X25519, Arrays.reverseInPlace(BigIntegers.asUnsignedByteArray(((ECSecretBCPGKey)privPk).getX()))));
                    }
                    return this.implGetPrivateKeyEC(ecdhPub, (ECSecretBCPGKey)privPk);
                }
                case 25: {
                    return PrivateKeyFactory.createKey(this.getPrivateKeyInfo(EdECObjectIdentifiers.id_X25519, 32, Arrays.reverseInPlace(privPk.getEncoded())));
                }
                case 26: {
                    return PrivateKeyFactory.createKey(this.getPrivateKeyInfo(EdECObjectIdentifiers.id_X448, 56, Arrays.reverseInPlace(privPk.getEncoded())));
                }
                case 19: {
                    return this.implGetPrivateKeyEC((ECDSAPublicBCPGKey)pubPk.getKey(), (ECSecretBCPGKey)privPk);
                }
                case 22: {
                    if (((EdDSAPublicBCPGKey)pubPk.getKey()).getCurveOID().equals(EdECObjectIdentifiers.id_Ed448)) {
                        return this.implGetPrivateKeyPKCS8(EdECObjectIdentifiers.id_Ed448, 57, privPk);
                    }
                    return this.implGetPrivateKeyPKCS8(EdECObjectIdentifiers.id_Ed25519, 32, privPk);
                }
                case 27: {
                    return PrivateKeyFactory.createKey(this.getPrivateKeyInfo(EdECObjectIdentifiers.id_Ed25519, 32, privPk.getEncoded()));
                }
                case 28: {
                    return PrivateKeyFactory.createKey(this.getPrivateKeyInfo(EdECObjectIdentifiers.id_Ed448, 57, privPk.getEncoded()));
                }
                case 16: 
                case 20: {
                    ElGamalPublicBCPGKey elPub = (ElGamalPublicBCPGKey)pubPk.getKey();
                    ElGamalSecretBCPGKey elPriv = (ElGamalSecretBCPGKey)privPk;
                    return new ElGamalPrivateKeyParameters(elPriv.getX(), new ElGamalParameters(elPub.getP(), elPub.getG()));
                }
                case 1: 
                case 2: 
                case 3: {
                    RSAPublicBCPGKey rsaPub = (RSAPublicBCPGKey)pubPk.getKey();
                    RSASecretBCPGKey rsaPriv = (RSASecretBCPGKey)privPk;
                    return new RSAPrivateCrtKeyParameters(rsaPriv.getModulus(), rsaPub.getPublicExponent(), rsaPriv.getPrivateExponent(), rsaPriv.getPrimeP(), rsaPriv.getPrimeQ(), rsaPriv.getPrimeExponentP(), rsaPriv.getPrimeExponentQ(), rsaPriv.getCrtCoefficient());
                }
            }
            throw new PGPException("unknown public key algorithm encountered");
        }
        catch (PGPException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PGPException("Exception constructing key", e);
        }
    }

    public AsymmetricKeyParameter getPublicKey(PGPPublicKey publicKey) throws PGPException {
        PublicKeyPacket publicPk = publicKey.getPublicKeyPacket();
        try {
            switch (publicPk.getAlgorithm()) {
                case 17: {
                    DSAPublicBCPGKey dsaK = (DSAPublicBCPGKey)publicPk.getKey();
                    return new DSAPublicKeyParameters(dsaK.getY(), new DSAParameters(dsaK.getP(), dsaK.getQ(), dsaK.getG()));
                }
                case 18: {
                    ECDHPublicBCPGKey ecdhK = (ECDHPublicBCPGKey)publicPk.getKey();
                    if (ecdhK.getCurveOID().equals(CryptlibObjectIdentifiers.curvey25519)) {
                        byte[] pEnc = BigIntegers.asUnsignedByteArray(ecdhK.getEncodedPoint());
                        if (pEnc.length < 1 || 64 != pEnc[0]) {
                            throw new IllegalArgumentException("Invalid Curve25519 public key");
                        }
                        return this.implGetPublicKeyX509(EdECObjectIdentifiers.id_X25519, pEnc, 1);
                    }
                    return this.implGetPublicKeyEC(ecdhK);
                }
                case 25: {
                    return this.implGetPublicKeyX509((X25519PublicBCPGKey)publicPk.getKey(), EdECObjectIdentifiers.id_X25519);
                }
                case 26: {
                    return this.implGetPublicKeyX509((X448PublicBCPGKey)publicPk.getKey(), EdECObjectIdentifiers.id_X448);
                }
                case 19: {
                    return this.implGetPublicKeyEC((ECDSAPublicBCPGKey)publicPk.getKey());
                }
                case 22: {
                    EdDSAPublicBCPGKey eddsaK = (EdDSAPublicBCPGKey)publicPk.getKey();
                    byte[] pEnc = BigIntegers.asUnsignedByteArray(eddsaK.getEncodedPoint());
                    if (pEnc.length < 1) {
                        throw new IllegalArgumentException("Invalid EdDSA public key");
                    }
                    if (pEnc[0] == 64 && !eddsaK.getCurveOID().equals(EdECObjectIdentifiers.id_Ed448)) {
                        return this.implGetPublicKeyX509(EdECObjectIdentifiers.id_Ed25519, pEnc, 1);
                    }
                    if (eddsaK.getCurveOID().equals(EdECObjectIdentifiers.id_Ed448)) {
                        return this.implGetPublicKeyX509(EdECObjectIdentifiers.id_Ed448, pEnc, 0);
                    }
                    throw new IllegalArgumentException("Invalid EdDSA public key");
                }
                case 27: {
                    return this.implGetPublicKeyX509((Ed25519PublicBCPGKey)publicPk.getKey(), EdECObjectIdentifiers.id_Ed25519);
                }
                case 28: {
                    return this.implGetPublicKeyX509((Ed448PublicBCPGKey)publicPk.getKey(), EdECObjectIdentifiers.id_Ed448);
                }
                case 16: 
                case 20: {
                    ElGamalPublicBCPGKey elK = (ElGamalPublicBCPGKey)publicPk.getKey();
                    return new ElGamalPublicKeyParameters(elK.getY(), new ElGamalParameters(elK.getP(), elK.getG()));
                }
                case 1: 
                case 2: 
                case 3: {
                    RSAPublicBCPGKey rsaK = (RSAPublicBCPGKey)publicPk.getKey();
                    return new RSAKeyParameters(false, rsaK.getModulus(), rsaK.getPublicExponent());
                }
            }
            throw new PGPException("unknown public key algorithm encountered");
        }
        catch (PGPException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PGPException("exception constructing public key", e);
        }
    }

    private BCPGKey getPrivateBCPGKey(PGPPublicKey pubKey, AsymmetricKeyParameter privKey) throws PGPException {
        switch (pubKey.getAlgorithm()) {
            case 17: {
                DSAPrivateKeyParameters dsK = (DSAPrivateKeyParameters)privKey;
                return new DSASecretBCPGKey(dsK.getX());
            }
            case 18: {
                if (privKey instanceof X25519PrivateKeyParameters) {
                    return new ECSecretBCPGKey(new BigInteger(1, Arrays.reverseInPlace(((X25519PrivateKeyParameters)privKey).getEncoded())));
                }
                ECPrivateKeyParameters ecK = (ECPrivateKeyParameters)privKey;
                return new ECSecretBCPGKey(ecK.getD());
            }
            case 25: {
                return new X25519SecretBCPGKey(Arrays.reverseInPlace(((X25519PrivateKeyParameters)privKey).getEncoded()));
            }
            case 26: {
                return new X448SecretBCPGKey(Arrays.reverseInPlace(((X448PrivateKeyParameters)privKey).getEncoded()));
            }
            case 19: {
                ECPrivateKeyParameters ecK = (ECPrivateKeyParameters)privKey;
                return new ECSecretBCPGKey(ecK.getD());
            }
            case 22: {
                return new EdSecretBCPGKey(new BigInteger(1, ((Ed25519PrivateKeyParameters)privKey).getEncoded()));
            }
            case 27: {
                return new Ed25519SecretBCPGKey(((Ed25519PrivateKeyParameters)privKey).getEncoded());
            }
            case 28: {
                return new Ed448SecretBCPGKey(((Ed448PrivateKeyParameters)privKey).getEncoded());
            }
            case 16: 
            case 20: {
                ElGamalPrivateKeyParameters esK = (ElGamalPrivateKeyParameters)privKey;
                return new ElGamalSecretBCPGKey(esK.getX());
            }
            case 1: 
            case 2: 
            case 3: {
                RSAPrivateCrtKeyParameters rsK = (RSAPrivateCrtKeyParameters)privKey;
                return new RSASecretBCPGKey(rsK.getExponent(), rsK.getP(), rsK.getQ());
            }
        }
        throw new PGPException("unknown key class");
    }

    private BCPGKey getPublicBCPGKey(int algorithm, PGPAlgorithmParameters algorithmParameters, AsymmetricKeyParameter pubKey) throws PGPException {
        if (pubKey instanceof RSAKeyParameters) {
            RSAKeyParameters rK = (RSAKeyParameters)pubKey;
            return new RSAPublicBCPGKey(rK.getModulus(), rK.getExponent());
        }
        if (pubKey instanceof DSAPublicKeyParameters) {
            DSAPublicKeyParameters dK = (DSAPublicKeyParameters)pubKey;
            DSAParameters dP = dK.getParameters();
            return new DSAPublicBCPGKey(dP.getP(), dP.getQ(), dP.getG(), dK.getY());
        }
        if (pubKey instanceof ElGamalPublicKeyParameters) {
            ElGamalPublicKeyParameters eK = (ElGamalPublicKeyParameters)pubKey;
            ElGamalParameters eS = eK.getParameters();
            return new ElGamalPublicBCPGKey(eS.getP(), eS.getG(), eK.getY());
        }
        if (pubKey instanceof ECPublicKeyParameters) {
            ECPublicKeyParameters ecK = (ECPublicKeyParameters)pubKey;
            ECNamedDomainParameters parameters = (ECNamedDomainParameters)ecK.getParameters();
            if (algorithm == 18) {
                PGPKdfParameters kdfParams = this.implGetKdfParameters(parameters.getName(), algorithmParameters);
                return new ECDHPublicBCPGKey(parameters.getName(), ecK.getQ(), kdfParams.getHashAlgorithm(), kdfParams.getSymmetricWrapAlgorithm());
            }
            if (algorithm == 19) {
                return new ECDSAPublicBCPGKey(parameters.getName(), ecK.getQ());
            }
            throw new PGPException("unknown EC algorithm");
        }
        if (algorithm == 27) {
            byte[] pointEnc = new byte[32];
            ((Ed25519PublicKeyParameters)pubKey).encode(pointEnc, 0);
            return new Ed25519PublicBCPGKey(pointEnc);
        }
        if (pubKey instanceof Ed25519PublicKeyParameters) {
            byte[] pointEnc = new byte[33];
            pointEnc[0] = 64;
            ((Ed25519PublicKeyParameters)pubKey).encode(pointEnc, 1);
            return new EdDSAPublicBCPGKey(GNUObjectIdentifiers.Ed25519, new BigInteger(1, pointEnc));
        }
        if (pubKey instanceof Ed448PublicKeyParameters) {
            byte[] pointEnc = new byte[57];
            ((Ed448PublicKeyParameters)pubKey).encode(pointEnc, 0);
            return new Ed448PublicBCPGKey(pointEnc);
        }
        if (algorithm == 25) {
            byte[] pointEnc = new byte[32];
            ((X25519PublicKeyParameters)pubKey).encode(pointEnc, 0);
            return new X25519PublicBCPGKey(pointEnc);
        }
        if (pubKey instanceof X25519PublicKeyParameters) {
            byte[] pointEnc = new byte[33];
            pointEnc[0] = 64;
            ((X25519PublicKeyParameters)pubKey).encode(pointEnc, 1);
            PGPKdfParameters kdfParams = this.implGetKdfParameters(CryptlibObjectIdentifiers.curvey25519, algorithmParameters);
            return new ECDHPublicBCPGKey(CryptlibObjectIdentifiers.curvey25519, new BigInteger(1, pointEnc), kdfParams.getHashAlgorithm(), kdfParams.getSymmetricWrapAlgorithm());
        }
        if (pubKey instanceof X448PublicKeyParameters) {
            byte[] pointEnc = new byte[56];
            ((X448PublicKeyParameters)pubKey).encode(pointEnc, 0);
            return new X448PublicBCPGKey(pointEnc);
        }
        throw new PGPException("unknown key class");
    }

    private AsymmetricKeyParameter implGetPublicKeyX509(OctetArrayBCPGKey eddsaK, ASN1ObjectIdentifier algorithm) throws IOException {
        byte[] pEnc = Arrays.clone(eddsaK.getKey());
        return PublicKeyFactory.createKey(new SubjectPublicKeyInfo(new AlgorithmIdentifier(algorithm), Arrays.copyOfRange(pEnc, 0, pEnc.length)));
    }

    private AsymmetricKeyParameter implGetPublicKeyX509(ASN1ObjectIdentifier algorithm, byte[] pEnc, int pEncOff) throws IOException {
        return PublicKeyFactory.createKey(new SubjectPublicKeyInfo(new AlgorithmIdentifier(algorithm), Arrays.copyOfRange(pEnc, pEncOff, pEnc.length)));
    }

    private ECNamedDomainParameters implGetParametersEC(ECPublicBCPGKey ecPub) {
        ASN1ObjectIdentifier curveOID = ecPub.getCurveOID();
        X9ECParameters x9 = BcUtil.getX9Parameters(curveOID);
        return new ECNamedDomainParameters(curveOID, x9.getCurve(), x9.getG(), x9.getN(), x9.getH());
    }

    private AsymmetricKeyParameter implGetPrivateKeyEC(ECPublicBCPGKey ecPub, ECSecretBCPGKey ecPriv) throws PGPException {
        ECNamedDomainParameters parameters = this.implGetParametersEC(ecPub);
        return new ECPrivateKeyParameters(ecPriv.getX(), (ECDomainParameters)parameters);
    }

    private AsymmetricKeyParameter implGetPrivateKeyPKCS8(ASN1ObjectIdentifier algorithm, int keySize, BCPGKey privPk) throws IOException {
        return PrivateKeyFactory.createKey(this.getPrivateKeyInfo(algorithm, BigIntegers.asUnsignedByteArray(keySize, ((EdSecretBCPGKey)privPk).getX())));
    }

    private AsymmetricKeyParameter implGetPublicKeyEC(ECPublicBCPGKey ecPub) throws PGPException {
        ECNamedDomainParameters parameters = this.implGetParametersEC(ecPub);
        ECPoint pubPoint = BcUtil.decodePoint(ecPub.getEncodedPoint(), parameters.getCurve());
        return new ECPublicKeyParameters(pubPoint, (ECDomainParameters)parameters);
    }
}

