/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.openpgp.operator.bc;

import java.io.IOException;
import java.math.BigInteger;
import net.savignano.thirdparty.org.bouncycastle.asn1.cryptlib.CryptlibObjectIdentifiers;
import net.savignano.thirdparty.org.bouncycastle.bcpg.AEADEncDataPacket;
import net.savignano.thirdparty.org.bouncycastle.bcpg.ECDHPublicBCPGKey;
import net.savignano.thirdparty.org.bouncycastle.bcpg.SymmetricEncIntegrityPacket;
import net.savignano.thirdparty.org.bouncycastle.crypto.AsymmetricBlockCipher;
import net.savignano.thirdparty.org.bouncycastle.crypto.BlockCipher;
import net.savignano.thirdparty.org.bouncycastle.crypto.BufferedAsymmetricBlockCipher;
import net.savignano.thirdparty.org.bouncycastle.crypto.InvalidCipherTextException;
import net.savignano.thirdparty.org.bouncycastle.crypto.RawAgreement;
import net.savignano.thirdparty.org.bouncycastle.crypto.Wrapper;
import net.savignano.thirdparty.org.bouncycastle.crypto.agreement.ECDHBasicAgreement;
import net.savignano.thirdparty.org.bouncycastle.crypto.agreement.X25519Agreement;
import net.savignano.thirdparty.org.bouncycastle.crypto.agreement.X448Agreement;
import net.savignano.thirdparty.org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import net.savignano.thirdparty.org.bouncycastle.crypto.params.ECDomainParameters;
import net.savignano.thirdparty.org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import net.savignano.thirdparty.org.bouncycastle.crypto.params.ECPublicKeyParameters;
import net.savignano.thirdparty.org.bouncycastle.crypto.params.ElGamalPrivateKeyParameters;
import net.savignano.thirdparty.org.bouncycastle.crypto.params.KeyParameter;
import net.savignano.thirdparty.org.bouncycastle.crypto.params.X25519PublicKeyParameters;
import net.savignano.thirdparty.org.bouncycastle.crypto.params.X448PublicKeyParameters;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPException;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPPrivateKey;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPSessionKey;
import net.savignano.thirdparty.org.bouncycastle.openpgp.operator.PGPDataDecryptor;
import net.savignano.thirdparty.org.bouncycastle.openpgp.operator.PGPPad;
import net.savignano.thirdparty.org.bouncycastle.openpgp.operator.PublicKeyDataDecryptorFactory;
import net.savignano.thirdparty.org.bouncycastle.openpgp.operator.RFC6637Utils;
import net.savignano.thirdparty.org.bouncycastle.openpgp.operator.bc.BcAEADUtil;
import net.savignano.thirdparty.org.bouncycastle.openpgp.operator.bc.BcImplProvider;
import net.savignano.thirdparty.org.bouncycastle.openpgp.operator.bc.BcKeyFingerprintCalculator;
import net.savignano.thirdparty.org.bouncycastle.openpgp.operator.bc.BcPGPDigestCalculatorProvider;
import net.savignano.thirdparty.org.bouncycastle.openpgp.operator.bc.BcPGPKeyConverter;
import net.savignano.thirdparty.org.bouncycastle.openpgp.operator.bc.BcUtil;
import net.savignano.thirdparty.org.bouncycastle.openpgp.operator.bc.RFC6637KDFCalculator;
import net.savignano.thirdparty.org.bouncycastle.util.Arrays;
import net.savignano.thirdparty.org.bouncycastle.util.BigIntegers;

public class BcPublicKeyDataDecryptorFactory
implements PublicKeyDataDecryptorFactory {
    private static final BcPGPKeyConverter KEY_CONVERTER = new BcPGPKeyConverter();
    private final PGPPrivateKey pgpPrivKey;

    public BcPublicKeyDataDecryptorFactory(PGPPrivateKey pgpPrivKey) {
        this.pgpPrivKey = pgpPrivKey;
    }

    @Override
    public byte[] recoverSessionData(int keyAlgorithm, byte[][] secKeyData) throws PGPException {
        try {
            AsymmetricKeyParameter privKey = KEY_CONVERTER.getPrivateKey(this.pgpPrivKey);
            if (keyAlgorithm == 25) {
                return this.getSessionData(secKeyData[0], privKey, 32, 8, 7, new X25519Agreement(), "X25519", new PublicKeyParametersOperation(){

                    @Override
                    public AsymmetricKeyParameter getPublicKeyParameters(byte[] pEnc, int pEncOff) {
                        return new X25519PublicKeyParameters(pEnc, 0);
                    }
                });
            }
            if (keyAlgorithm == 26) {
                return this.getSessionData(secKeyData[0], privKey, 56, 10, 9, new X448Agreement(), "X448", new PublicKeyParametersOperation(){

                    @Override
                    public AsymmetricKeyParameter getPublicKeyParameters(byte[] pEnc, int pEncOff) {
                        return new X448PublicKeyParameters(pEnc, 0);
                    }
                });
            }
            if (keyAlgorithm == 18) {
                byte[] secret;
                byte[] enc = secKeyData[0];
                int pLen = (((enc[0] & 0xFF) << 8) + (enc[1] & 0xFF) + 7) / 8;
                BcPublicKeyDataDecryptorFactory.assertOutOfRange(2 + pLen + 1, enc);
                byte[] pEnc = new byte[pLen];
                System.arraycopy(enc, 2, pEnc, 0, pLen);
                int keyLen = enc[pLen + 2] & 0xFF;
                BcPublicKeyDataDecryptorFactory.assertOutOfRange(2 + pLen + 1 + keyLen, enc);
                byte[] keyEnc = new byte[keyLen];
                System.arraycopy(enc, 2 + pLen + 1, keyEnc, 0, keyLen);
                ECDHPublicBCPGKey ecPubKey = (ECDHPublicBCPGKey)this.pgpPrivKey.getPublicKeyPacket().getKey();
                if (ecPubKey.getCurveOID().equals(CryptlibObjectIdentifiers.curvey25519)) {
                    if (pEnc.length != 33 || 64 != pEnc[0]) {
                        throw new IllegalArgumentException("Invalid Curve25519 public key");
                    }
                    secret = BcUtil.getSecret(new X25519Agreement(), privKey, new X25519PublicKeyParameters(pEnc, 1));
                } else {
                    ECDomainParameters ecParameters = ((ECPrivateKeyParameters)privKey).getParameters();
                    ECPublicKeyParameters ephPub = new ECPublicKeyParameters(ecParameters.getCurve().decodePoint(pEnc), ecParameters);
                    ECDHBasicAgreement agreement = new ECDHBasicAgreement();
                    agreement.init(privKey);
                    BigInteger S = agreement.calculateAgreement(ephPub);
                    secret = BigIntegers.asUnsignedByteArray(agreement.getFieldSize(), S);
                }
                byte hashAlgorithm = ecPubKey.getHashAlgorithm();
                byte symmetricKeyAlgorithm = ecPubKey.getSymmetricKeyAlgorithm();
                byte[] userKeyingMaterial = RFC6637Utils.createUserKeyingMaterial(this.pgpPrivKey.getPublicKeyPacket(), new BcKeyFingerprintCalculator());
                RFC6637KDFCalculator rfc6637KDFCalculator = new RFC6637KDFCalculator(new BcPGPDigestCalculatorProvider().get(hashAlgorithm), symmetricKeyAlgorithm);
                KeyParameter key = new KeyParameter(rfc6637KDFCalculator.createKey(secret, userKeyingMaterial));
                return PGPPad.unpadSessionData(BcPublicKeyDataDecryptorFactory.unwrapSessionData(keyEnc, symmetricKeyAlgorithm, key));
            }
            AsymmetricBlockCipher c = BcImplProvider.createPublicKeyCipher(keyAlgorithm);
            BufferedAsymmetricBlockCipher c1 = new BufferedAsymmetricBlockCipher(c);
            c1.init(false, privKey);
            if (keyAlgorithm == 2 || keyAlgorithm == 1) {
                byte[] bi = secKeyData[0];
                c1.processBytes(bi, 2, bi.length - 2);
            } else {
                ElGamalPrivateKeyParameters parms = (ElGamalPrivateKeyParameters)privKey;
                int size = (parms.getParameters().getP().bitLength() + 7) / 8;
                byte[] tmp = new byte[size];
                byte[] bi = secKeyData[0];
                if (bi.length - 2 > size) {
                    c1.processBytes(bi, 3, bi.length - 3);
                } else {
                    System.arraycopy(bi, 2, tmp, tmp.length - (bi.length - 2), bi.length - 2);
                    c1.processBytes(tmp, 0, tmp.length);
                }
                bi = secKeyData[1];
                Arrays.fill(tmp, (byte)0);
                if (bi.length - 2 > size) {
                    c1.processBytes(bi, 3, bi.length - 3);
                } else {
                    System.arraycopy(bi, 2, tmp, tmp.length - (bi.length - 2), bi.length - 2);
                    c1.processBytes(tmp, 0, tmp.length);
                }
            }
            return c1.doFinal();
        }
        catch (IOException e) {
            throw new PGPException("exception creating user keying material: " + e.getMessage(), e);
        }
        catch (InvalidCipherTextException e) {
            throw new PGPException("exception decrypting session info: " + e.getMessage(), e);
        }
    }

    @Override
    public PGPDataDecryptor createDataDecryptor(boolean withIntegrityPacket, int encAlgorithm, byte[] key) throws PGPException {
        BlockCipher engine = BcImplProvider.createBlockCipher(encAlgorithm);
        return BcUtil.createDataDecryptor(withIntegrityPacket, engine, key);
    }

    @Override
    public PGPDataDecryptor createDataDecryptor(AEADEncDataPacket aeadEncDataPacket, PGPSessionKey sessionKey) throws PGPException {
        return BcAEADUtil.createOpenPgpV5DataDecryptor(aeadEncDataPacket, sessionKey);
    }

    @Override
    public PGPDataDecryptor createDataDecryptor(SymmetricEncIntegrityPacket seipd, PGPSessionKey sessionKey) throws PGPException {
        return BcAEADUtil.createOpenPgpV6DataDecryptor(seipd, sessionKey);
    }

    private byte[] getSessionData(byte[] enc, AsymmetricKeyParameter privKey, int pLen, int hashAlgorithm, int symmetricKeyAlgorithm, RawAgreement agreement, String algorithmName, PublicKeyParametersOperation pkp) throws PGPException, InvalidCipherTextException {
        byte[] pEnc = new byte[pLen];
        System.arraycopy(enc, 0, pEnc, 0, pLen);
        int keyLen = enc[pLen] & 0xFF;
        BcPublicKeyDataDecryptorFactory.assertOutOfRange(pLen + 1 + keyLen, enc);
        byte[] keyEnc = new byte[keyLen - 1];
        System.arraycopy(enc, pLen + 2, keyEnc, 0, keyEnc.length);
        byte[] secret = BcUtil.getSecret(agreement, privKey, pkp.getPublicKeyParameters(pEnc, 0));
        KeyParameter key = new KeyParameter(RFC6637KDFCalculator.createKey(hashAlgorithm, symmetricKeyAlgorithm, Arrays.concatenate(pEnc, this.pgpPrivKey.getPublicKeyPacket().getKey().getEncoded(), secret), "OpenPGP " + algorithmName));
        return Arrays.concatenate(new byte[]{enc[pLen + 1]}, BcPublicKeyDataDecryptorFactory.unwrapSessionData(keyEnc, symmetricKeyAlgorithm, key));
    }

    private static byte[] unwrapSessionData(byte[] keyEnc, int symmetricKeyAlgorithm, KeyParameter key) throws PGPException, InvalidCipherTextException {
        Wrapper c = BcImplProvider.createWrapper(symmetricKeyAlgorithm);
        c.init(false, key);
        return c.unwrap(keyEnc, 0, keyEnc.length);
    }

    private static void assertOutOfRange(int pLen, byte[] enc) throws PGPException {
        if (pLen > enc.length) {
            throw new PGPException("encoded length out of range");
        }
    }

    @FunctionalInterface
    private static interface PublicKeyParametersOperation {
        public AsymmetricKeyParameter getPublicKeyParameters(byte[] var1, int var2);
    }
}

