/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.openpgp.operator.jcajce;

import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.Provider;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import net.savignano.thirdparty.org.bouncycastle.bcpg.AEADEncDataPacket;
import net.savignano.thirdparty.org.bouncycastle.bcpg.SymmetricEncIntegrityPacket;
import net.savignano.thirdparty.org.bouncycastle.bcpg.SymmetricKeyEncSessionPacket;
import net.savignano.thirdparty.org.bouncycastle.bcpg.SymmetricKeyUtils;
import net.savignano.thirdparty.org.bouncycastle.crypto.digests.SHA256Digest;
import net.savignano.thirdparty.org.bouncycastle.crypto.generators.HKDFBytesGenerator;
import net.savignano.thirdparty.org.bouncycastle.crypto.params.HKDFParameters;
import net.savignano.thirdparty.org.bouncycastle.jcajce.util.DefaultJcaJceHelper;
import net.savignano.thirdparty.org.bouncycastle.jcajce.util.NamedJcaJceHelper;
import net.savignano.thirdparty.org.bouncycastle.jcajce.util.ProviderJcaJceHelper;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPException;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPSessionKey;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPUtil;
import net.savignano.thirdparty.org.bouncycastle.openpgp.operator.PBEDataDecryptorFactory;
import net.savignano.thirdparty.org.bouncycastle.openpgp.operator.PGPDataDecryptor;
import net.savignano.thirdparty.org.bouncycastle.openpgp.operator.PGPDigestCalculatorProvider;
import net.savignano.thirdparty.org.bouncycastle.openpgp.operator.jcajce.JcaPGPDigestCalculatorProviderBuilder;
import net.savignano.thirdparty.org.bouncycastle.openpgp.operator.jcajce.JceAEADCipherUtil;
import net.savignano.thirdparty.org.bouncycastle.openpgp.operator.jcajce.JceAEADUtil;
import net.savignano.thirdparty.org.bouncycastle.openpgp.operator.jcajce.OperatorHelper;

public class JcePBEDataDecryptorFactoryBuilder {
    private OperatorHelper helper = new OperatorHelper(new DefaultJcaJceHelper());
    private JceAEADUtil aeadHelper = new JceAEADUtil(this.helper);
    private PGPDigestCalculatorProvider calculatorProvider;

    public JcePBEDataDecryptorFactoryBuilder() {
        this.calculatorProvider = null;
    }

    public JcePBEDataDecryptorFactoryBuilder(PGPDigestCalculatorProvider calculatorProvider) {
        this.calculatorProvider = calculatorProvider;
    }

    public JcePBEDataDecryptorFactoryBuilder setProvider(Provider provider) {
        this.helper = new OperatorHelper(new ProviderJcaJceHelper(provider));
        this.aeadHelper = new JceAEADUtil(this.helper);
        return this;
    }

    public JcePBEDataDecryptorFactoryBuilder setProvider(String providerName) {
        this.helper = new OperatorHelper(new NamedJcaJceHelper(providerName));
        this.aeadHelper = new JceAEADUtil(this.helper);
        return this;
    }

    public PBEDataDecryptorFactory build(char[] passPhrase) {
        if (this.calculatorProvider == null) {
            try {
                this.calculatorProvider = new JcaPGPDigestCalculatorProviderBuilder(this.helper).build();
            }
            catch (PGPException e) {
                throw new IllegalStateException("digest calculator provider cannot be built with current helper: " + e.getMessage());
            }
        }
        return new PBEDataDecryptorFactory(passPhrase, this.calculatorProvider){

            @Override
            public byte[] recoverSessionData(int keyAlgorithm, byte[] key, byte[] secKeyData) throws PGPException {
                try {
                    if (secKeyData != null && secKeyData.length > 0) {
                        String cipherName = PGPUtil.getSymmetricCipherName(keyAlgorithm);
                        Cipher keyCipher = JcePBEDataDecryptorFactoryBuilder.this.helper.createCipher(cipherName + "/CFB/NoPadding");
                        keyCipher.init(2, (Key)new SecretKeySpec(key, cipherName), new IvParameterSpec(new byte[keyCipher.getBlockSize()]));
                        return keyCipher.doFinal(secKeyData);
                    }
                    byte[] keyBytes = new byte[key.length + 1];
                    keyBytes[0] = (byte)keyAlgorithm;
                    System.arraycopy(key, 0, keyBytes, 1, key.length);
                    return keyBytes;
                }
                catch (Exception e) {
                    throw new PGPException("Exception recovering session info", e);
                }
            }

            @Override
            public byte[] recoverAEADEncryptedSessionData(SymmetricKeyEncSessionPacket keyData, byte[] ikm) throws PGPException {
                byte[] sessionData;
                if (keyData.getVersion() < 5) {
                    throw new PGPException("SKESK packet MUST be version 5 or later.");
                }
                byte[] hkdfInfo = keyData.getAAData();
                int kekLen = SymmetricKeyUtils.getKeyLengthInOctets(keyData.getEncAlgorithm());
                byte[] kek = new byte[kekLen];
                HKDFBytesGenerator hkdfGen = new HKDFBytesGenerator(new SHA256Digest());
                hkdfGen.init(new HKDFParameters(ikm, null, hkdfInfo));
                hkdfGen.generateBytes(kek, 0, kek.length);
                SecretKeySpec secretKey = new SecretKeySpec(kek, PGPUtil.getSymmetricCipherName(keyData.getEncAlgorithm()));
                Cipher aead = JcePBEDataDecryptorFactoryBuilder.this.aeadHelper.createAEADCipher(keyData.getEncAlgorithm(), keyData.getAeadAlgorithm());
                int aeadMacLen = 128;
                byte[] authTag = keyData.getAuthTag();
                byte[] aeadIv = keyData.getIv();
                byte[] encSessionKey = keyData.getSecKeyData();
                byte[] buf = new byte[encSessionKey.length + authTag.length];
                System.arraycopy(encSessionKey, 0, buf, 0, encSessionKey.length);
                System.arraycopy(authTag, 0, buf, encSessionKey.length, authTag.length);
                try {
                    JceAEADCipherUtil.setUpAeadCipher(aead, secretKey, 2, aeadIv, aeadMacLen, hkdfInfo);
                    sessionData = aead.doFinal(buf, 0, buf.length);
                }
                catch (GeneralSecurityException e) {
                    throw new PGPException("unable to open stream: " + e.getMessage());
                }
                return sessionData;
            }

            @Override
            public PGPDataDecryptor createDataDecryptor(boolean withIntegrityPacket, int encAlgorithm, byte[] key) throws PGPException {
                return JcePBEDataDecryptorFactoryBuilder.this.helper.createDataDecryptor(withIntegrityPacket, encAlgorithm, key);
            }

            @Override
            public PGPDataDecryptor createDataDecryptor(AEADEncDataPacket aeadEncDataPacket, PGPSessionKey sessionKey) throws PGPException {
                return JcePBEDataDecryptorFactoryBuilder.this.aeadHelper.createOpenPgpV5DataDecryptor(aeadEncDataPacket, sessionKey);
            }

            @Override
            public PGPDataDecryptor createDataDecryptor(SymmetricEncIntegrityPacket seipd, PGPSessionKey sessionKey) throws PGPException {
                return JcePBEDataDecryptorFactoryBuilder.this.aeadHelper.createOpenPgpV6DataDecryptor(seipd, sessionKey);
            }
        };
    }
}

