/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.openssl;

import java.io.IOException;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1InputStream;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Primitive;
import net.savignano.thirdparty.org.bouncycastle.cert.X509CertificateHolder;
import net.savignano.thirdparty.org.bouncycastle.openssl.CertificateTrustBlock;
import net.savignano.thirdparty.org.bouncycastle.util.Arrays;

public class X509TrustedCertificateBlock {
    private final X509CertificateHolder certificateHolder;
    private final CertificateTrustBlock trustBlock;

    public X509TrustedCertificateBlock(X509CertificateHolder certificateHolder, CertificateTrustBlock trustBlock) {
        this.certificateHolder = certificateHolder;
        this.trustBlock = trustBlock;
    }

    public X509TrustedCertificateBlock(byte[] encoding) throws IOException {
        ASN1InputStream aIn = new ASN1InputStream(encoding);
        this.certificateHolder = new X509CertificateHolder(aIn.readObject().getEncoded());
        ASN1Primitive tBlock = aIn.readObject();
        this.trustBlock = tBlock != null ? new CertificateTrustBlock(tBlock.getEncoded()) : null;
    }

    public byte[] getEncoded() throws IOException {
        return Arrays.concatenate(this.certificateHolder.getEncoded(), this.trustBlock.toASN1Sequence().getEncoded());
    }

    public X509CertificateHolder getCertificateHolder() {
        return this.certificateHolder;
    }

    public CertificateTrustBlock getTrustBlock() {
        return this.trustBlock;
    }
}

