/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.pqc.asn1;

import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1EncodableVector;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Object;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1OctetString;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Primitive;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Sequence;
import net.savignano.thirdparty.org.bouncycastle.asn1.DEROctetString;
import net.savignano.thirdparty.org.bouncycastle.asn1.DERSequence;
import net.savignano.thirdparty.org.bouncycastle.util.Arrays;

public class SABERPublicKey
extends ASN1Object {
    private byte[] seed_A;
    private byte[] b;

    public SABERPublicKey(byte[] seed_A, byte[] b) {
        this.seed_A = seed_A;
        this.b = b;
    }

    private SABERPublicKey(ASN1Sequence seq) {
        this.seed_A = Arrays.clone(ASN1OctetString.getInstance(seq.getObjectAt(0)).getOctets());
        this.b = Arrays.clone(ASN1OctetString.getInstance(seq.getObjectAt(1)).getOctets());
    }

    public byte[] getSeed_A() {
        return this.seed_A;
    }

    public byte[] getB() {
        return this.b;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add(new DEROctetString(this.seed_A));
        v.add(new DEROctetString(this.b));
        return new DERSequence(v);
    }

    public static SABERPublicKey getInstance(Object o) {
        if (o instanceof SABERPublicKey) {
            return (SABERPublicKey)o;
        }
        if (o != null) {
            return new SABERPublicKey(ASN1Sequence.getInstance(o));
        }
        return null;
    }
}

