/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.pqc.crypto.crystals.kyber;

import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.crystals.kyber.CBD;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.crystals.kyber.KyberEngine;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.crystals.kyber.Ntt;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.crystals.kyber.Reduce;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.crystals.kyber.Symmetric;

class Poly {
    private short[] coeffs = new short[256];
    private KyberEngine engine;
    private int polyCompressedBytes;
    private int eta1;
    private int eta2;
    private Symmetric symmetric;

    public Poly(KyberEngine engine) {
        this.engine = engine;
        this.polyCompressedBytes = engine.getKyberPolyCompressedBytes();
        this.eta1 = engine.getKyberEta1();
        this.eta2 = KyberEngine.getKyberEta2();
        this.symmetric = engine.getSymmetric();
    }

    public short getCoeffIndex(int i) {
        return this.coeffs[i];
    }

    public short[] getCoeffs() {
        return this.coeffs;
    }

    public void setCoeffIndex(int i, short val) {
        this.coeffs[i] = val;
    }

    public void setCoeffs(short[] coeffs) {
        this.coeffs = coeffs;
    }

    public void polyNtt() {
        this.setCoeffs(Ntt.ntt(this.getCoeffs()));
        this.reduce();
    }

    public void polyInverseNttToMont() {
        this.setCoeffs(Ntt.invNtt(this.getCoeffs()));
    }

    public void reduce() {
        for (int i = 0; i < 256; ++i) {
            this.setCoeffIndex(i, Reduce.barretReduce(this.getCoeffIndex(i)));
        }
    }

    public static void baseMultMontgomery(Poly r, Poly a, Poly b) {
        for (int i = 0; i < 64; ++i) {
            Ntt.baseMult(r, 4 * i, a.getCoeffIndex(4 * i), a.getCoeffIndex(4 * i + 1), b.getCoeffIndex(4 * i), b.getCoeffIndex(4 * i + 1), Ntt.nttZetas[64 + i]);
            Ntt.baseMult(r, 4 * i + 2, a.getCoeffIndex(4 * i + 2), a.getCoeffIndex(4 * i + 3), b.getCoeffIndex(4 * i + 2), b.getCoeffIndex(4 * i + 3), (short)(-1 * Ntt.nttZetas[64 + i]));
        }
    }

    public void addCoeffs(Poly b) {
        for (int i = 0; i < 256; ++i) {
            this.setCoeffIndex(i, (short)(this.getCoeffIndex(i) + b.getCoeffIndex(i)));
        }
    }

    public void convertToMont() {
        int f = 1353;
        for (int i = 0; i < 256; ++i) {
            this.setCoeffIndex(i, Reduce.montgomeryReduce(this.getCoeffIndex(i) * 1353));
        }
    }

    public byte[] compressPoly() {
        byte[] t = new byte[8];
        byte[] r = new byte[this.polyCompressedBytes];
        int count = 0;
        this.conditionalSubQ();
        if (this.polyCompressedBytes == 128) {
            for (int i = 0; i < 32; ++i) {
                for (int j = 0; j < 8; ++j) {
                    int t_j = this.getCoeffIndex(8 * i + j);
                    t_j <<= 4;
                    t_j += 1665;
                    t_j *= 80635;
                    t_j >>= 28;
                    t[j] = (byte)(t_j &= 0xF);
                }
                r[count + 0] = (byte)(t[0] | t[1] << 4);
                r[count + 1] = (byte)(t[2] | t[3] << 4);
                r[count + 2] = (byte)(t[4] | t[5] << 4);
                r[count + 3] = (byte)(t[6] | t[7] << 4);
                count += 4;
            }
        } else if (this.polyCompressedBytes == 160) {
            for (int i = 0; i < 32; ++i) {
                for (int j = 0; j < 8; ++j) {
                    int t_j = this.getCoeffIndex(8 * i + j);
                    t_j <<= 5;
                    t_j += 1664;
                    t_j *= 40318;
                    t_j >>= 27;
                    t[j] = (byte)(t_j &= 0x1F);
                }
                r[count + 0] = (byte)(t[0] >> 0 | t[1] << 5);
                r[count + 1] = (byte)(t[1] >> 3 | t[2] << 2 | t[3] << 7);
                r[count + 2] = (byte)(t[3] >> 1 | t[4] << 4);
                r[count + 3] = (byte)(t[4] >> 4 | t[5] << 1 | t[6] << 6);
                r[count + 4] = (byte)(t[6] >> 2 | t[7] << 3);
                count += 5;
            }
        } else {
            throw new RuntimeException("PolyCompressedBytes is neither 128 or 160!");
        }
        return r;
    }

    public void decompressPoly(byte[] compressedPolyCipherText) {
        int count = 0;
        if (this.engine.getKyberPolyCompressedBytes() == 128) {
            for (int i = 0; i < 128; ++i) {
                this.setCoeffIndex(2 * i + 0, (short)((short)(compressedPolyCipherText[count] & 0xFF & 0xF) * 3329 + 8 >> 4));
                this.setCoeffIndex(2 * i + 1, (short)((short)((compressedPolyCipherText[count] & 0xFF) >> 4) * 3329 + 8 >> 4));
                ++count;
            }
        } else if (this.engine.getKyberPolyCompressedBytes() == 160) {
            byte[] t = new byte[8];
            for (int i = 0; i < 32; ++i) {
                t[0] = (byte)((compressedPolyCipherText[count + 0] & 0xFF) >> 0);
                t[1] = (byte)((compressedPolyCipherText[count + 0] & 0xFF) >> 5 | (compressedPolyCipherText[count + 1] & 0xFF) << 3);
                t[2] = (byte)((compressedPolyCipherText[count + 1] & 0xFF) >> 2);
                t[3] = (byte)((compressedPolyCipherText[count + 1] & 0xFF) >> 7 | (compressedPolyCipherText[count + 2] & 0xFF) << 1);
                t[4] = (byte)((compressedPolyCipherText[count + 2] & 0xFF) >> 4 | (compressedPolyCipherText[count + 3] & 0xFF) << 4);
                t[5] = (byte)((compressedPolyCipherText[count + 3] & 0xFF) >> 1);
                t[6] = (byte)((compressedPolyCipherText[count + 3] & 0xFF) >> 6 | (compressedPolyCipherText[count + 4] & 0xFF) << 2);
                t[7] = (byte)((compressedPolyCipherText[count + 4] & 0xFF) >> 3);
                count += 5;
                for (int j = 0; j < 8; ++j) {
                    this.setCoeffIndex(8 * i + j, (short)((t[j] & 0x1F) * 3329 + 16 >> 5));
                }
            }
        } else {
            throw new RuntimeException("PolyCompressedBytes is neither 128 or 160!");
        }
    }

    public byte[] toBytes() {
        byte[] r = new byte[384];
        this.conditionalSubQ();
        for (int i = 0; i < 128; ++i) {
            short t0 = this.getCoeffIndex(2 * i);
            short t1 = this.getCoeffIndex(2 * i + 1);
            r[3 * i] = (byte)(t0 >> 0);
            r[3 * i + 1] = (byte)(t0 >> 8 | t1 << 4);
            r[3 * i + 2] = (byte)(t1 >> 4);
        }
        return r;
    }

    public void fromBytes(byte[] inpBytes) {
        for (int i = 0; i < 128; ++i) {
            this.setCoeffIndex(2 * i, (short)(((inpBytes[3 * i + 0] & 0xFF) >> 0 | (inpBytes[3 * i + 1] & 0xFF) << 8) & 0xFFF));
            this.setCoeffIndex(2 * i + 1, (short)(((long)((inpBytes[3 * i + 1] & 0xFF) >> 4) | (long)((inpBytes[3 * i + 2] & 0xFF) << 4)) & 0xFFFL));
        }
    }

    public byte[] toMsg() {
        byte[] outMsg = new byte[KyberEngine.getKyberIndCpaMsgBytes()];
        this.conditionalSubQ();
        for (int i = 0; i < 32; ++i) {
            outMsg[i] = 0;
            for (int j = 0; j < 8; ++j) {
                int t = this.getCoeffIndex(8 * i + j) & 0xFFFF;
                t <<= 1;
                t += 1665;
                t *= 80635;
                t >>= 28;
                int n = i;
                outMsg[n] = (byte)(outMsg[n] | (byte)((t &= 1) << j));
            }
        }
        return outMsg;
    }

    public void fromMsg(byte[] msg) {
        if (msg.length != 32) {
            throw new RuntimeException("KYBER_INDCPA_MSGBYTES must be equal to KYBER_N/8 bytes!");
        }
        for (int i = 0; i < 32; ++i) {
            for (int j = 0; j < 8; ++j) {
                short mask = (short)(-1 * (short)((msg[i] & 0xFF) >> j & 1));
                this.setCoeffIndex(8 * i + j, (short)(mask & 0x681));
            }
        }
    }

    public void conditionalSubQ() {
        for (int i = 0; i < 256; ++i) {
            this.setCoeffIndex(i, Reduce.conditionalSubQ(this.getCoeffIndex(i)));
        }
    }

    public void getEta1Noise(byte[] seed, byte nonce) {
        byte[] buf = new byte[256 * this.eta1 / 4];
        this.symmetric.prf(buf, seed, nonce);
        CBD.kyberCBD(this, buf, this.eta1);
    }

    public void getEta2Noise(byte[] seed, byte nonce) {
        byte[] buf = new byte[256 * this.eta2 / 4];
        this.symmetric.prf(buf, seed, nonce);
        CBD.kyberCBD(this, buf, this.eta2);
    }

    public void polySubtract(Poly b) {
        for (int i = 0; i < 256; ++i) {
            this.setCoeffIndex(i, (short)(b.getCoeffIndex(i) - this.getCoeffIndex(i)));
        }
    }

    public String toString() {
        StringBuffer out = new StringBuffer();
        out.append("[");
        for (int i = 0; i < this.coeffs.length; ++i) {
            out.append(this.coeffs[i]);
            if (i == this.coeffs.length - 1) continue;
            out.append(", ");
        }
        out.append("]");
        return out.toString();
    }
}

