/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.pqc.crypto.hqc;

import java.security.SecureRandom;
import net.savignano.thirdparty.org.bouncycastle.crypto.EncapsulatedSecretGenerator;
import net.savignano.thirdparty.org.bouncycastle.crypto.SecretWithEncapsulation;
import net.savignano.thirdparty.org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.hqc.HQCEngine;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.hqc.HQCPublicKeyParameters;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.util.SecretWithEncapsulationImpl;
import net.savignano.thirdparty.org.bouncycastle.util.Arrays;

public class HQCKEMGenerator
implements EncapsulatedSecretGenerator {
    private final SecureRandom sr;

    public HQCKEMGenerator(SecureRandom random) {
        this.sr = random;
    }

    @Override
    public SecretWithEncapsulation generateEncapsulated(AsymmetricKeyParameter recipientKey) {
        HQCPublicKeyParameters key = (HQCPublicKeyParameters)recipientKey;
        HQCEngine engine = key.getParameters().getEngine();
        byte[] K = new byte[key.getParameters().getSHA512_BYTES()];
        byte[] u = new byte[key.getParameters().getN_BYTES()];
        byte[] v = new byte[key.getParameters().getN1N2_BYTES()];
        byte[] d = new byte[key.getParameters().getSHA512_BYTES()];
        byte[] salt = new byte[key.getParameters().getSALT_SIZE_BYTES()];
        byte[] pk = key.getPublicKey();
        byte[] seed = new byte[48];
        this.sr.nextBytes(seed);
        engine.encaps(u, v, K, d, pk, seed, salt);
        byte[] cipherText = Arrays.concatenate(u, v, d, salt);
        return new SecretWithEncapsulationImpl(Arrays.copyOfRange(K, 0, key.getParameters().getK()), cipherText);
    }
}

