/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.pqc.crypto.picnic;

import java.security.SecureRandom;
import net.savignano.thirdparty.org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import net.savignano.thirdparty.org.bouncycastle.crypto.AsymmetricCipherKeyPairGenerator;
import net.savignano.thirdparty.org.bouncycastle.crypto.KeyGenerationParameters;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.picnic.PicnicEngine;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.picnic.PicnicKeyGenerationParameters;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.picnic.PicnicParameters;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.picnic.PicnicPrivateKeyParameters;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.picnic.PicnicPublicKeyParameters;

public class PicnicKeyPairGenerator
implements AsymmetricCipherKeyPairGenerator {
    private SecureRandom random;
    private PicnicParameters parameters;

    @Override
    public void init(KeyGenerationParameters param) {
        this.random = param.getRandom();
        this.parameters = ((PicnicKeyGenerationParameters)param).getParameters();
    }

    @Override
    public AsymmetricCipherKeyPair generateKeyPair() {
        PicnicEngine engine = this.parameters.getEngine();
        byte[] sk = new byte[engine.getSecretKeySize()];
        byte[] pk = new byte[engine.getPublicKeySize()];
        engine.crypto_sign_keypair(pk, sk, this.random);
        PicnicPublicKeyParameters pubKey = new PicnicPublicKeyParameters(this.parameters, pk);
        PicnicPrivateKeyParameters privKey = new PicnicPrivateKeyParameters(this.parameters, sk);
        return new AsymmetricCipherKeyPair(pubKey, privKey);
    }
}

