/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.pqc.crypto.rainbow;

import java.security.SecureRandom;
import net.savignano.thirdparty.org.bouncycastle.crypto.Digest;
import net.savignano.thirdparty.org.bouncycastle.util.Arrays;

class RainbowUtil {
    RainbowUtil() {
    }

    public static short[] convertArray(byte[] in) {
        short[] out = new short[in.length];
        for (int i = 0; i < in.length; ++i) {
            out[i] = (short)(in[i] & 0xFF);
        }
        return out;
    }

    public static byte[] convertArray(short[] in) {
        byte[] out = new byte[in.length];
        for (int i = 0; i < in.length; ++i) {
            out[i] = (byte)in[i];
        }
        return out;
    }

    public static boolean equals(short[] left, short[] right) {
        if (left.length != right.length) {
            return false;
        }
        boolean result = true;
        for (int i = left.length - 1; i >= 0; --i) {
            result &= left[i] == right[i];
        }
        return result;
    }

    public static boolean equals(short[][] left, short[][] right) {
        if (left.length != right.length) {
            return false;
        }
        boolean result = true;
        for (int i = left.length - 1; i >= 0; --i) {
            result &= RainbowUtil.equals(left[i], right[i]);
        }
        return result;
    }

    public static boolean equals(short[][][] left, short[][][] right) {
        if (left.length != right.length) {
            return false;
        }
        boolean result = true;
        for (int i = left.length - 1; i >= 0; --i) {
            result &= RainbowUtil.equals(left[i], right[i]);
        }
        return result;
    }

    public static short[][] cloneArray(short[][] toCopy) {
        short[][] local = new short[toCopy.length][];
        for (int i = 0; i < toCopy.length; ++i) {
            local[i] = Arrays.clone(toCopy[i]);
        }
        return local;
    }

    public static short[][][] cloneArray(short[][][] toCopy) {
        short[][][] local = new short[toCopy.length][toCopy[0].length][];
        for (int i = 0; i < toCopy.length; ++i) {
            for (int j = 0; j < toCopy[0].length; ++j) {
                local[i][j] = Arrays.clone(toCopy[i][j]);
            }
        }
        return local;
    }

    public static byte[] hash(Digest hashAlgo, byte[] partA, byte[] partB, byte[] result) {
        int digest_size = hashAlgo.getDigestSize();
        hashAlgo.update(partA, 0, partA.length);
        hashAlgo.update(partB, 0, partB.length);
        if (result.length == digest_size) {
            hashAlgo.doFinal(result, 0);
            return result;
        }
        byte[] hash = new byte[digest_size];
        hashAlgo.doFinal(hash, 0);
        if (result.length < digest_size) {
            System.arraycopy(hash, 0, result, 0, result.length);
            return result;
        }
        System.arraycopy(hash, 0, result, 0, hash.length);
        int left_to_hash = result.length - digest_size;
        int index = digest_size;
        while (left_to_hash >= hash.length) {
            hashAlgo.update(hash, 0, hash.length);
            hashAlgo.doFinal(hash, 0);
            System.arraycopy(hash, 0, result, index, hash.length);
            left_to_hash -= hash.length;
            index += hash.length;
        }
        if (left_to_hash > 0) {
            hashAlgo.update(hash, 0, hash.length);
            hashAlgo.doFinal(hash, 0);
            System.arraycopy(hash, 0, result, index, left_to_hash);
        }
        return result;
    }

    public static byte[] hash(Digest hashAlgo, byte[] msg, int hash_length) {
        int left_to_hash;
        int digest_size = hashAlgo.getDigestSize();
        hashAlgo.update(msg, 0, msg.length);
        byte[] hash = new byte[digest_size];
        hashAlgo.doFinal(hash, 0);
        if (hash_length == digest_size) {
            return hash;
        }
        if (hash_length < digest_size) {
            return Arrays.copyOf(hash, hash_length);
        }
        byte[] final_hash = Arrays.copyOf(hash, digest_size);
        for (left_to_hash = hash_length - digest_size; left_to_hash >= digest_size; left_to_hash -= digest_size) {
            hashAlgo.update(hash, 0, digest_size);
            hash = new byte[digest_size];
            hashAlgo.doFinal(hash, 0);
            final_hash = Arrays.concatenate(final_hash, hash);
        }
        if (left_to_hash > 0) {
            hashAlgo.update(hash, 0, digest_size);
            hash = new byte[digest_size];
            hashAlgo.doFinal(hash, 0);
            int current_length = final_hash.length;
            final_hash = Arrays.copyOf(final_hash, current_length + left_to_hash);
            System.arraycopy(hash, 0, final_hash, current_length, left_to_hash);
        }
        return final_hash;
    }

    public static short[][] generate_random_2d(SecureRandom sr, int dim_row, int dim_col) {
        byte[] tmp = new byte[dim_row * dim_col];
        sr.nextBytes(tmp);
        short[][] matrix = new short[dim_row][dim_col];
        for (int j = 0; j < dim_col; ++j) {
            for (int i = 0; i < dim_row; ++i) {
                matrix[i][j] = (short)(tmp[j * dim_row + i] & 0xFF);
            }
        }
        return matrix;
    }

    public static short[][][] generate_random(SecureRandom sr, int dim_batch, int dim_row, int dim_col, boolean triangular) {
        int bytes_needed = triangular ? dim_batch * (dim_row * (dim_row + 1) / 2) : dim_batch * dim_row * dim_col;
        byte[] tmp = new byte[bytes_needed];
        sr.nextBytes(tmp);
        int index = 0;
        short[][][] matrix = new short[dim_batch][dim_row][dim_col];
        for (int i = 0; i < dim_row; ++i) {
            for (int j = 0; j < dim_col; ++j) {
                for (int k = 0; k < dim_batch; ++k) {
                    if (triangular && i > j) continue;
                    matrix[k][i][j] = (short)(tmp[index++] & 0xFF);
                }
            }
        }
        return matrix;
    }

    public static byte[] getEncoded(short[][] a) {
        int row = a.length;
        int col = a[0].length;
        byte[] ret = new byte[row * col];
        for (int j = 0; j < col; ++j) {
            for (int i = 0; i < row; ++i) {
                ret[j * row + i] = (byte)a[i][j];
            }
        }
        return ret;
    }

    public static byte[] getEncoded(short[][][] a, boolean triangular) {
        int dim = a.length;
        int row = a[0].length;
        int col = a[0][0].length;
        int ret_size = triangular ? dim * (row * (row + 1) / 2) : dim * row * col;
        byte[] ret = new byte[ret_size];
        int cnt = 0;
        for (int i = 0; i < row; ++i) {
            for (int j = 0; j < col; ++j) {
                for (int k = 0; k < dim; ++k) {
                    if (triangular && i > j) continue;
                    ret[cnt] = (byte)a[k][i][j];
                    ++cnt;
                }
            }
        }
        return ret;
    }

    public static int loadEncoded(short[][] a, byte[] enc, int off) {
        int row = a.length;
        int col = a[0].length;
        for (int j = 0; j < col; ++j) {
            for (int i = 0; i < row; ++i) {
                a[i][j] = (short)(enc[off + j * row + i] & 0xFF);
            }
        }
        return row * col;
    }

    public static int loadEncoded(short[][][] a, byte[] enc, int off, boolean triangular) {
        int dim = a.length;
        int row = a[0].length;
        int col = a[0][0].length;
        int cnt = 0;
        for (int i = 0; i < row; ++i) {
            for (int j = 0; j < col; ++j) {
                for (int k = 0; k < dim; ++k) {
                    if (triangular && i > j) continue;
                    a[k][i][j] = (short)(enc[off + cnt++] & 0xFF);
                }
            }
        }
        return cnt;
    }
}

