/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.pqc.crypto.saber;

import java.security.SecureRandom;
import net.savignano.thirdparty.org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import net.savignano.thirdparty.org.bouncycastle.crypto.AsymmetricCipherKeyPairGenerator;
import net.savignano.thirdparty.org.bouncycastle.crypto.KeyGenerationParameters;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.saber.SABEREngine;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.saber.SABERKeyGenerationParameters;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.saber.SABERPrivateKeyParameters;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.saber.SABERPublicKeyParameters;

public class SABERKeyPairGenerator
implements AsymmetricCipherKeyPairGenerator {
    private SABERKeyGenerationParameters saberParams;
    private int l;
    private SecureRandom random;

    private void initialize(KeyGenerationParameters param) {
        this.saberParams = (SABERKeyGenerationParameters)param;
        this.random = param.getRandom();
        this.l = this.saberParams.getParameters().getL();
    }

    private AsymmetricCipherKeyPair genKeyPair() {
        SABEREngine engine = this.saberParams.getParameters().getEngine();
        byte[] sk = new byte[engine.getPrivateKeySize()];
        byte[] pk = new byte[engine.getPublicKeySize()];
        engine.crypto_kem_keypair(pk, sk, this.random);
        SABERPublicKeyParameters pubKey = new SABERPublicKeyParameters(this.saberParams.getParameters(), pk);
        SABERPrivateKeyParameters privKey = new SABERPrivateKeyParameters(this.saberParams.getParameters(), sk);
        return new AsymmetricCipherKeyPair(pubKey, privKey);
    }

    @Override
    public void init(KeyGenerationParameters param) {
        this.initialize(param);
    }

    @Override
    public AsymmetricCipherKeyPair generateKeyPair() {
        return this.genKeyPair();
    }
}

