/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.util.io;

import java.io.OutputStream;

public class LimitedBuffer
extends OutputStream {
    private final byte[] buf;
    private int count;

    public LimitedBuffer(int limit) {
        this.buf = new byte[limit];
        this.count = 0;
    }

    public int copyTo(byte[] b, int off) {
        System.arraycopy(this.buf, 0, b, off, this.count);
        return this.count;
    }

    public int limit() {
        return this.buf.length;
    }

    public void reset() {
        this.count = 0;
    }

    public int size() {
        return this.count;
    }

    @Override
    public void write(int b) {
        this.buf[this.count++] = (byte)b;
    }

    @Override
    public void write(byte[] b) {
        System.arraycopy(b, 0, this.buf, this.count, b.length);
        this.count += b.length;
    }

    @Override
    public void write(byte[] b, int off, int len) {
        System.arraycopy(b, off, this.buf, this.count, len);
        this.count += len;
    }
}

