/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.atlassian.mailer.util;

import jakarta.mail.NoSuchProviderException;
import jakarta.mail.Provider;
import jakarta.mail.Session;
import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MailProviderEnforcer {
    private static final Logger log = LoggerFactory.getLogger(MailProviderEnforcer.class);
    private static final String PROPERTY_KEY = "snotify.javamailProviderDynamicOverride";
    public static final MailProviderEnforcer INSTANCE = new MailProviderEnforcer();
    private final Set<Class<?>> enforcedProviders = new HashSet();

    private MailProviderEnforcer() {
    }

    public boolean shouldEnforce() {
        return Boolean.getBoolean(PROPERTY_KEY);
    }

    public void enforceProvider(Provider provider) {
        if (provider == null || this.enforcedProviders.contains(provider.getClass())) {
            return;
        }
        Thread.ofVirtual().start(() -> this.setAsDefault(provider));
    }

    private void setAsDefault(Provider provider) {
        int tries = 0;
        while (tries < 3 && !this.isDefaultSessionSet()) {
            try {
                Thread.sleep((long)Math.pow(10.0, ++tries));
            }
            catch (InterruptedException e) {
                log.error("Installing of S/Notify provider \"" + provider.toString() + "\" interrupted.", (Throwable)e);
                return;
            }
        }
        try {
            Session.getDefaultInstance((Properties)System.getProperties()).setProvider(provider);
        }
        catch (NoSuchProviderException e) {
            log.error("Could not instantiate S/Notify provider \"" + provider.toString() + "\".", (Throwable)e);
            return;
        }
        log.info("S/Notify provider \"{}\" set as default.", (Object)provider.toString());
        this.enforcedProviders.add(provider.getClass());
    }

    private boolean isDefaultSessionSet() {
        try {
            Field field = Session.class.getField("defaultSession");
            field.trySetAccessible();
            boolean set = field.get(null) != null;
            log.trace("Default Sessions set: {}", (Object)set);
            return set;
        }
        catch (IllegalAccessException e) {
            log.debug("Access denied to \"defaultSession\" field of Session class.", (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            log.debug("\"defaultSession\" not a static field in Session class.", (Throwable)e);
        }
        catch (NoSuchFieldException e) {
            log.debug("\"defaultSession\" field not present in Session class. Maybe different implementation of jakarta mail?", (Throwable)e);
        }
        catch (SecurityException e) {
            log.debug("Security violation accessing \"defaultSession\" field of Session class.", (Throwable)e);
        }
        return true;
    }
}

