/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.atlassian.mailer.util;

import jakarta.mail.Message;
import jakarta.mail.MessagingException;
import jakarta.mail.Part;
import jakarta.mail.Session;
import jakarta.mail.internet.MimeMessage;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import net.savignano.cryptography.util.MessageUtil;
import net.savignano.snotify.atlassian.mailer.SnotifyMimeMessage;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageBuilder {
    private static final String SNOTFY_IMG = "data:image/png;base64,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";
    private static final Logger log = LoggerFactory.getLogger(MessageBuilder.class);
    private final Message orgMsg;
    private final Session session;
    private URL sourceLink;
    private String sourceText;
    private URL additional;
    private URL replace;

    public MessageBuilder(Message orgMsg, Session session) {
        this.orgMsg = orgMsg;
        this.session = session;
        if (orgMsg == null) {
            throw new IllegalArgumentException("Original message must not be null.");
        }
        if (session == null) {
            throw new IllegalArgumentException("Session must not be null.");
        }
    }

    public void sourceLink(String sourceLink) {
        if (sourceLink == null) {
            this.sourceLink((URL)null);
        } else {
            try {
                this.sourceLink(new URL(sourceLink));
            }
            catch (MalformedURLException e) {
                log.error("Source Link is not an URL. Error message: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    public void sourceLink(URL sourceLink) {
        this.sourceLink = sourceLink;
    }

    public void sourceText(String sourceText) {
        this.sourceText = sourceText;
    }

    public void additional(String file) {
        File additional = file == null ? null : new File(file);
        this.additional(additional);
    }

    public void additional(File file) {
        URL url = this.toUrl(file);
        this.additional(url);
    }

    public void additional(URL url) {
        this.additional = url;
    }

    public void replace(String file) {
        File replace = file == null ? null : new File(file);
        this.replace(replace);
    }

    public void replace(File file) {
        URL url = this.toUrl(file);
        this.replace(url);
    }

    public void replace(URL url) {
        this.replace = url;
    }

    private URL toUrl(File file) {
        URL url = null;
        if (file != null) {
            if (file.canRead()) {
                try {
                    url = file.toURI().toURL();
                }
                catch (MalformedURLException e) {
                    log.error("Could not convert file to URL. Error message: " + e.getMessage(), (Throwable)e);
                }
            } else {
                log.error("Cannot read file: {}", (Object)file);
            }
        }
        return url;
    }

    public MimeMessage buildMail(String payload) throws MessagingException {
        String replace = this.getReplace();
        SnotifyMimeMessage message = new SnotifyMimeMessage(this.session);
        MessageUtil.copyAllHeaders((Part)this.orgMsg, (Part)message);
        String content = replace == null ? this.createHtmlBody(payload) : replace;
        message.setText(content, "UTF-8", "html");
        message.saveChanges();
        return message;
    }

    private String createHtmlBody(String payload) {
        String sourceLink = this.getSourceLink();
        String additional = this.getAdditional();
        StringBuilder builder = new StringBuilder(65536);
        builder.append("<html><body>");
        builder.append("<table style=\"width:100%\"><tr>");
        builder.append("<td><img alt=\"S/Notify image\" height=\"60\" width=\"60\" style=\"padding-right:15px\" src=\"");
        builder.append(SNOTFY_IMG);
        builder.append("\"></td><td>");
        builder.append(payload);
        if (sourceLink != null) {
            builder.append(sourceLink);
        }
        if (additional != null) {
            builder.append(additional);
        }
        builder.append("</td></tr></table>");
        builder.append("</body></html>");
        return builder.toString();
    }

    private String getSourceLink() {
        if (this.sourceLink == null) {
            return null;
        }
        StringBuilder builder = new StringBuilder(200);
        builder.append("\n<p><a href=\"");
        builder.append(this.sourceLink);
        builder.append("\">");
        builder.append(this.sourceText != null ? this.sourceText : this.sourceLink);
        builder.append("</a></p>");
        return builder.toString();
    }

    private String getAdditional() {
        if (this.additional != null) {
            log.debug("Loading additional content to add to message from: {}", (Object)this.additional);
            return this.getContent(this.additional);
        }
        return null;
    }

    private String getReplace() {
        if (this.replace != null) {
            log.debug("Loading replacement content to replace message with from: {}", (Object)this.replace);
            return this.getContent(this.replace);
        }
        return null;
    }

    private String getContent(URL content) {
        String text = null;
        try (InputStreamReader reader = new InputStreamReader(content.openStream());){
            text = IOUtils.toString((Reader)reader);
            log.debug("Loaded content successfully.");
            log.trace("Loaded content: {}", (Object)text);
        }
        catch (IOException e) {
            log.error("Could not load content for report message. Error message: " + e.getMessage(), (Throwable)e);
        }
        return text;
    }
}

