/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.oer.its.ieee1609dot2;

import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Choice;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Encodable;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Object;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1OctetString;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Primitive;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1TaggedObject;
import net.savignano.thirdparty.org.bouncycastle.asn1.DEROctetString;
import net.savignano.thirdparty.org.bouncycastle.asn1.DERTaggedObject;
import net.savignano.thirdparty.org.bouncycastle.util.Arrays;

public class HashedData
extends ASN1Object
implements ASN1Choice {
    public static final int sha256HashedData = 0;
    public static final int sha384HashedData = 1;
    public static final int reserved = 2;
    private final int choice;
    private final ASN1Encodable hashedData;

    public HashedData(int choice, ASN1Encodable sha256HashedData) {
        this.choice = choice;
        this.hashedData = sha256HashedData;
    }

    private HashedData(ASN1TaggedObject dto) {
        switch (dto.getTagNo()) {
            case 0: 
            case 1: 
            case 2: {
                this.choice = dto.getTagNo();
                this.hashedData = DEROctetString.getInstance(dto.getExplicitBaseObject());
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid choice value " + dto.getTagNo());
            }
        }
    }

    public static HashedData sha256HashedData(ASN1OctetString sha256HashedData) {
        return new HashedData(0, sha256HashedData);
    }

    public static HashedData sha256HashedData(byte[] sha256HashedData) {
        return new HashedData(0, new DEROctetString(Arrays.clone(sha256HashedData)));
    }

    public static HashedData sha384HashedData(ASN1OctetString sha384HashedData) {
        return new HashedData(1, sha384HashedData);
    }

    public static HashedData sha384HashedData(byte[] sha384HashedData) {
        return new HashedData(1, new DEROctetString(Arrays.clone(sha384HashedData)));
    }

    public static HashedData reserved(ASN1OctetString reserved) {
        return new HashedData(2, reserved);
    }

    public static HashedData reserved(byte[] reserved) {
        return new HashedData(2, new DEROctetString(Arrays.clone(reserved)));
    }

    public static HashedData getInstance(Object o) {
        if (o instanceof HashedData) {
            return (HashedData)o;
        }
        if (o != null) {
            return new HashedData(ASN1TaggedObject.getInstance(o, 128));
        }
        return null;
    }

    public int getChoice() {
        return this.choice;
    }

    public ASN1Encodable getHashedData() {
        return this.hashedData;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        return new DERTaggedObject(this.choice, this.hashedData);
    }
}

