/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.cryptography.key.loader;

import java.util.function.Function;
import net.savignano.cryptography.enums.ECryptographyType;
import net.savignano.cryptography.enums.EKeySource;
import net.savignano.cryptography.key.ICryptographyKey;
import net.savignano.cryptography.key.loader.IKeyLoader;

public class KeyLoaderTransformer<T extends ICryptographyKey<?>, U, V>
implements IKeyLoader<T, U> {
    private final IKeyLoader<T, V> loader;
    private final Function<U, V> transformer;

    public static final <T extends ICryptographyKey<?>, U, V> IKeyLoader<T, U> create(IKeyLoader<T, V> loader, Function<U, V> transformer) {
        return new KeyLoaderTransformer<T, U, V>(loader, transformer);
    }

    public KeyLoaderTransformer(IKeyLoader<T, V> loader, Function<U, V> transformer) {
        this.loader = loader;
        this.transformer = transformer;
        if (loader == null) {
            throw new IllegalArgumentException("Loader must not be null.");
        }
        if (transformer == null) {
            throw new IllegalArgumentException("Transformer must not be null.");
        }
    }

    @Override
    public T loadKey(U forId) {
        return this.loader.loadKey(this.transformer.apply(forId));
    }

    @Override
    public EKeySource getKeySource() {
        return this.loader.getKeySource();
    }

    @Override
    public ECryptographyType getCryptography() {
        return this.loader.getCryptography();
    }
}

