/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.cryptography.mail.sign;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Part;
import javax.mail.Session;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimeUtility;
import javax.mail.util.ByteArrayDataSource;
import net.savignano.cryptography.Constants;
import net.savignano.cryptography.enums.ECryptographyType;
import net.savignano.cryptography.key.pgp.PgpSignKey;
import net.savignano.cryptography.mail.protect.ProtectedHeadersMailHeaderProtector;
import net.savignano.cryptography.mail.sign.AMailSigner;
import net.savignano.cryptography.mail.sign.PgpSigningResult;
import net.savignano.cryptography.util.MessageUtil;
import net.savignano.cryptography.util.PgpUtil;
import net.savignano.thirdparty.org.bouncycastle.bcpg.ArmoredOutputStream;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPException;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPPublicKey;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPPublicKeyRing;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPSecretKey;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.apache.commons.io.IOUtils;

public class PgpMailSigner
extends AMailSigner<PgpSignKey, PgpSigningResult> {
    private boolean includePublicKey;

    public PgpMailSigner(Session session) {
        super(session, ECryptographyType.PGP);
    }

    @Override
    protected PgpSigningResult createResult(MimeMessage msg) {
        return new PgpSigningResult(msg);
    }

    @Override
    protected void sign(PgpSignKey key, PgpSigningResult result) throws Exception {
        MimeMessage msg = result.getMessage();
        BodyPart toSign = this.createContentPart(msg);
        if (this.isIncludePublicKey()) {
            BodyPart keyPart = this.createKeyPart(key);
            toSign = this.wrapContentAndKeys(toSign, keyPart);
        }
        int algorithm = 8;
        BodyPart signaturePart = this.createSignaturePart(toSign, key, 8);
        String multiSubType = MimeUtility.fold((int)("Content-Type".length() + "multipart/".length()), (String)"signed; protocol=\"application/pgp-signature\"; micalg=\"pgp-sha256\"");
        MimeMultipart signedMulti = new MimeMultipart(multiSubType);
        signedMulti.addBodyPart(toSign);
        signedMulti.addBodyPart(signaturePart);
        String hashName = PgpUtil.getHashName(8);
        this.includeSignatureHeader(msg, hashName);
        MessageUtil.removeMatchingHeaders((Part)msg, Constants.STRUCTURAL_MIME_HEADERS);
        msg.setContent((Multipart)signedMulti);
        msg.saveChanges();
    }

    private BodyPart createContentPart(MimeMessage msg) throws IOException, MessagingException {
        String contentType = msg.getContentType();
        this.getLog().debug("Signing content of type: {}", (Object)contentType);
        MimeBodyPart toSign = new MimeBodyPart();
        MessageUtil.movePart((Part)msg, (Part)toSign);
        if (ProtectedHeadersMailHeaderProtector.isProtectedHeaders(contentType)) {
            MessageUtil.copyMatchingHeaders((Part)msg, (Part)toSign, Constants.USER_FACING_MIME_HEADERS);
        }
        return toSign;
    }

    private BodyPart wrapContentAndKeys(BodyPart contentPart, BodyPart keyPart) throws MessagingException {
        MimeMultipart mp = new MimeMultipart();
        mp.addBodyPart(contentPart);
        mp.addBodyPart(keyPart);
        MimeBodyPart wrappedPart = new MimeBodyPart();
        wrappedPart.setContent((Multipart)mp);
        wrappedPart.setHeader("Content-Type", mp.getContentType());
        MimeMessage dummy = new MimeMessage(this.getSession());
        dummy.setContent((Multipart)mp);
        dummy.saveChanges();
        return wrappedPart;
    }

    private BodyPart createKeyPart(PgpSignKey signKey) throws MessagingException, IOException {
        byte[] keyBytes;
        ArrayList<PGPPublicKey> publicKeys = new ArrayList<PGPPublicKey>();
        PGPSecretKeyRing secretRing = signKey.getKeyRing();
        secretRing.getPublicKeys().forEachRemaining(k -> publicKeys.add((PGPPublicKey)k));
        PGPPublicKeyRing ring = new PGPPublicKeyRing(publicKeys);
        byte[] key = ring.getEncoded(true);
        try (ByteArrayInputStream is = new ByteArrayInputStream(ring.getEncoded(true));){
            ByteArrayOutputStream baos = new ByteArrayOutputStream(3 * key.length);
            try (ArmoredOutputStream os = new ArmoredOutputStream(baos);){
                IOUtils.copy((InputStream)is, (OutputStream)os);
            }
            keyBytes = baos.toByteArray();
        }
        MimeBodyPart keyPart = new MimeBodyPart();
        ByteArrayDataSource dsKey = new ByteArrayDataSource(keyBytes, "application/pgp-keys");
        keyPart.setDataHandler(new DataHandler((DataSource)dsKey));
        keyPart.setDescription(this.enhanceWithProduct("PGP keys"));
        keyPart.setDisposition("attachment; filename=\"key.asc\"");
        return keyPart;
    }

    private BodyPart createSignaturePart(BodyPart toSign, PgpSignKey signKey, int algorithm) throws IOException, MessagingException, PGPException {
        byte[] signedBytes;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        toSign.writeTo((OutputStream)baos);
        this.getLog().debug("Signing message with key: {}", (Object)signKey);
        try {
            byte[] bytes = baos.toByteArray();
            PGPSecretKey key = signKey.getKey();
            char[] password = signKey.getPassword();
            signedBytes = PgpUtil.sign(bytes, key, password, algorithm, true);
        }
        catch (PGPException e) {
            if ("checksum mismatch at in checksum of 20 bytes".equals(e.getMessage())) {
                throw new PGPException("Supplied password was wrong to extract private key.", e);
            }
            throw e;
        }
        MimeBodyPart signedPart = new MimeBodyPart();
        ByteArrayDataSource dsSigned = new ByteArrayDataSource(signedBytes, "application/pgp-signature");
        signedPart.setDataHandler(new DataHandler((DataSource)dsSigned));
        signedPart.setDescription(this.enhanceWithProduct("PGP digital signature"));
        signedPart.setDisposition("attachment; filename=\"signature.asc\"");
        return signedPart;
    }

    private String enhanceWithProduct(String text) {
        if (this.getProductInfo() == null) {
            return text;
        }
        String product = this.getProductInfo().getProduct();
        if (product == null) {
            return text;
        }
        return product + " - " + text;
    }

    public boolean isIncludePublicKey() {
        return this.includePublicKey;
    }

    public void setIncludePublicKey(boolean includePublicKey) {
        this.includePublicKey = includePublicKey;
    }
}

